/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java9.util.Maps;
import java9.util.Sets;

class Config {
    private static final int DEFAULT_THRESHOLD = 100;
    private static final int DEFAULT_OFFSET = 0;
    private static final Boolean DEFAULT_INTERNAL_EXCEPTION_CAPTURE = true;
    @SerializedName(value="threshold")
    private final Integer threshold;
    @SerializedName(value="offset")
    private final Integer offset;
    @SerializedName(value="screenshots_enabled")
    private final Boolean screenshotsEnabled;
    @SerializedName(value="signal_strength_enabled")
    private final Boolean signalStrengthEnabled;
    @SerializedName(value="event_limits")
    private final Map<String, Long> eventLimits;
    @SerializedName(value="disabled_message_types")
    private final Set<String> disabledMessageTypes;
    @SerializedName(value="disabled_event_and_log_patterns")
    private final Set<String> disabledEventAndLogPatterns;
    @SerializedName(value="disabled_url_patterns")
    private final Set<String> disabledUrlPatterns;
    @SerializedName(value="disabled_screenshot_patterns")
    private final Set<String> disabledScreenshotPatterns;
    @SerializedName(value="ui")
    private final UiConfig uiConfig;
    @SerializedName(value="network")
    private final NetworkConfig networkConfig;
    @SerializedName(value="session_control")
    private final SessionControl sessionControl;
    @SerializedName(value="logs")
    private final LogConfig logConfig;
    @SerializedName(value="internal_exception_capture_enabled")
    private final Boolean internalExceptionCaptureEnabled;

    Config(Integer threshold, Integer offset, Boolean screenshotsEnabled, Boolean signalStrengthEnabled, Map<String, Long> eventLimits, Set<String> disabledMessageTypes, Set<String> disabledEventAndLogPatterns, Set<String> disabledUrlPatterns, Set<String> disabledScreenshotPatterns, UiConfig uiConfig, NetworkConfig networkConfig, SessionControl sessionControl, LogConfig logConfig, Boolean internalExceptionCaptureEnabled) {
        this.threshold = threshold;
        this.offset = offset;
        this.screenshotsEnabled = screenshotsEnabled;
        this.signalStrengthEnabled = signalStrengthEnabled;
        this.eventLimits = eventLimits;
        this.disabledMessageTypes = disabledMessageTypes;
        this.disabledEventAndLogPatterns = disabledEventAndLogPatterns;
        this.disabledUrlPatterns = disabledUrlPatterns;
        this.disabledScreenshotPatterns = disabledScreenshotPatterns;
        this.uiConfig = uiConfig;
        this.networkConfig = networkConfig;
        this.sessionControl = sessionControl;
        this.logConfig = logConfig;
        this.internalExceptionCaptureEnabled = internalExceptionCaptureEnabled;
    }

    static Config ofDefault() {
        return new Config(100, 0, true, false, Maps.of(), Sets.of(), Sets.of(), Sets.of(), Sets.of(), new UiConfig(null, null, null, null, null), new NetworkConfig(null, null), new SessionControl(true), new LogConfig(null), DEFAULT_INTERNAL_EXCEPTION_CAPTURE);
    }

    Integer getThreshold() {
        return this.threshold != null ? this.threshold : 100;
    }

    Integer getOffset() {
        return this.offset != null ? this.offset : 0;
    }

    Boolean getScreenshotsEnabled() {
        return this.screenshotsEnabled != null ? this.screenshotsEnabled : true;
    }

    Boolean getSignalStrengthEnabled() {
        return this.signalStrengthEnabled != null ? this.signalStrengthEnabled : false;
    }

    Map<String, Long> getEventLimits() {
        return this.eventLimits != null ? this.eventLimits : new HashMap<String, Long>();
    }

    Set<String> getDisabledMessageTypes() {
        return this.disabledMessageTypes != null ? this.disabledMessageTypes : new HashSet<String>();
    }

    Set<String> getDisabledEventAndLogPatterns() {
        return this.disabledEventAndLogPatterns != null ? this.disabledEventAndLogPatterns : new HashSet<String>();
    }

    Set<String> getDisabledUrlPatterns() {
        return this.disabledUrlPatterns != null ? this.disabledUrlPatterns : new HashSet<String>();
    }

    Set<String> getDisabledScreenshotPatterns() {
        return this.disabledScreenshotPatterns != null ? this.disabledScreenshotPatterns : new HashSet<String>();
    }

    Optional<Integer> getCustomBreadcrumbLimit() {
        return this.uiConfig == null ? Optional.absent() : this.uiConfig.getBreadcrumbs();
    }

    Optional<Integer> getFragmentBreadcrumbLimit() {
        return this.uiConfig == null ? Optional.absent() : this.uiConfig.getFragments();
    }

    Optional<Integer> getViewBreadcrumbLimit() {
        return this.uiConfig == null ? Optional.absent() : this.uiConfig.getViews();
    }

    Optional<Integer> getTapBreadcrumbLimit() {
        return this.uiConfig == null ? Optional.absent() : this.uiConfig.getTaps();
    }

    Optional<Integer> getWebViewBreadcrumbLimit() {
        return this.uiConfig == null ? Optional.absent() : this.uiConfig.getWebViews();
    }

    Optional<Integer> getDefaultNetworkCallLimit() {
        return this.networkConfig == null ? Optional.absent() : this.networkConfig.getDefaultCaptureLimit();
    }

    Map<String, Integer> getNetworkCallLimitsPerDomain() {
        return this.networkConfig == null ? new HashMap() : this.networkConfig.getDomainLimits();
    }

    Boolean getSessionControl() {
        return this.sessionControl == null || this.sessionControl.isEnabled();
    }

    Optional<Integer> getLogMessageMaximumAllowedLength() {
        return this.logConfig == null ? Optional.absent() : this.logConfig.getLogMessageMaximumAllowedLength();
    }

    Boolean getInternalExceptionCaptureEnabled() {
        return this.internalExceptionCaptureEnabled != null ? this.internalExceptionCaptureEnabled : DEFAULT_INTERNAL_EXCEPTION_CAPTURE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        if (this.threshold != null ? !this.threshold.equals(config.threshold) : config.threshold != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(config.offset) : config.offset != null) {
            return false;
        }
        if (this.screenshotsEnabled != null ? !this.screenshotsEnabled.equals(config.screenshotsEnabled) : config.screenshotsEnabled != null) {
            return false;
        }
        if (this.signalStrengthEnabled != null ? !this.signalStrengthEnabled.equals(config.signalStrengthEnabled) : config.signalStrengthEnabled != null) {
            return false;
        }
        if (this.eventLimits != null ? !this.eventLimits.equals(config.eventLimits) : config.eventLimits != null) {
            return false;
        }
        if (this.disabledMessageTypes != null ? !this.disabledMessageTypes.equals(config.disabledMessageTypes) : config.disabledMessageTypes != null) {
            return false;
        }
        if (this.disabledEventAndLogPatterns != null ? !this.disabledEventAndLogPatterns.equals(config.disabledEventAndLogPatterns) : config.disabledEventAndLogPatterns != null) {
            return false;
        }
        if (this.disabledUrlPatterns != null ? !this.disabledUrlPatterns.equals(config.disabledUrlPatterns) : config.disabledUrlPatterns != null) {
            return false;
        }
        if (this.disabledScreenshotPatterns != null ? !this.disabledScreenshotPatterns.equals(config.disabledScreenshotPatterns) : config.disabledScreenshotPatterns != null) {
            return false;
        }
        if (this.uiConfig != null ? !this.uiConfig.equals(config.uiConfig) : config.uiConfig != null) {
            return false;
        }
        if (this.sessionControl != null ? !this.sessionControl.equals(config.sessionControl) : config.sessionControl != null) {
            return false;
        }
        if (this.networkConfig != null ? !this.networkConfig.equals(config.networkConfig) : config.networkConfig != null) {
            return false;
        }
        return this.logConfig != null ? this.logConfig.equals(config.logConfig) : config.logConfig == null;
    }

    public int hashCode() {
        int result = this.threshold != null ? this.threshold.hashCode() : 0;
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.screenshotsEnabled != null ? this.screenshotsEnabled.hashCode() : 0);
        result = 31 * result + (this.signalStrengthEnabled != null ? this.signalStrengthEnabled.hashCode() : 0);
        result = 31 * result + (this.eventLimits != null ? this.eventLimits.hashCode() : 0);
        result = 31 * result + (this.disabledMessageTypes != null ? this.disabledMessageTypes.hashCode() : 0);
        result = 31 * result + (this.disabledEventAndLogPatterns != null ? this.disabledEventAndLogPatterns.hashCode() : 0);
        result = 31 * result + (this.disabledUrlPatterns != null ? this.disabledUrlPatterns.hashCode() : 0);
        result = 31 * result + (this.disabledScreenshotPatterns != null ? this.disabledScreenshotPatterns.hashCode() : 0);
        result = 31 * result + (this.uiConfig != null ? this.uiConfig.hashCode() : 0);
        result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
        result = 31 * result + (this.sessionControl != null ? this.sessionControl.hashCode() : 0);
        result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Config{threshold=" + this.threshold + ", offset=" + this.offset + ", screenshotsEnabled=" + this.screenshotsEnabled + ", signalStrengthEnabled=" + this.signalStrengthEnabled + ", eventLimits=" + this.eventLimits + ", disabledMessageTypes=" + this.disabledMessageTypes + ", disabledEventAndLogPatterns=" + this.disabledEventAndLogPatterns + ", disabledUrlPatterns=" + this.disabledUrlPatterns + ", disabledScreenshotPatterns=" + this.disabledScreenshotPatterns + ", uiConfig=" + this.uiConfig + ", networkConfig=" + this.networkConfig + ", sessionControl=" + this.sessionControl + '}';
    }

    static class LogConfig {
        @SerializedName(value="max_length")
        private final Integer logMessageMaximumAllowedLength;

        LogConfig(Integer logMessageMaximumAllowedLength) {
            this.logMessageMaximumAllowedLength = logMessageMaximumAllowedLength;
        }

        Optional<Integer> getLogMessageMaximumAllowedLength() {
            return Optional.fromNullable((Object)this.logMessageMaximumAllowedLength);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogConfig that = (LogConfig)o;
            return this.logMessageMaximumAllowedLength != null ? this.logMessageMaximumAllowedLength.equals(that.logMessageMaximumAllowedLength) : that.logMessageMaximumAllowedLength == null;
        }

        public int hashCode() {
            int result = this.logMessageMaximumAllowedLength != null ? this.logMessageMaximumAllowedLength.hashCode() : 0;
            return result;
        }

        public String toString() {
            return "LogConfig{, logMessageMaximumAllowedLength=" + this.logMessageMaximumAllowedLength + '}';
        }
    }

    static class SessionControl {
        @SerializedName(value="enable")
        boolean enabled;

        SessionControl(boolean enabled) {
            this.enabled = enabled;
        }

        boolean isEnabled() {
            return this.enabled;
        }
    }

    static class NetworkConfig {
        private final Integer defaultCaptureLimit;
        @SerializedName(value="domains")
        private final Map<String, Integer> domainLimits;

        NetworkConfig(Integer defaultCaptureLimit, Map<String, Integer> domainLimits) {
            this.defaultCaptureLimit = defaultCaptureLimit;
            this.domainLimits = domainLimits;
        }

        Map<String, Integer> getDomainLimits() {
            return this.domainLimits == null ? new HashMap() : this.domainLimits;
        }

        Optional<Integer> getDefaultCaptureLimit() {
            return Optional.fromNullable((Object)this.defaultCaptureLimit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NetworkConfig that = (NetworkConfig)o;
            if (this.defaultCaptureLimit != null ? !this.defaultCaptureLimit.equals(that.defaultCaptureLimit) : that.defaultCaptureLimit != null) {
                return false;
            }
            return this.domainLimits != null ? this.domainLimits.equals(that.domainLimits) : that.domainLimits == null;
        }

        public int hashCode() {
            int result = this.defaultCaptureLimit != null ? this.defaultCaptureLimit.hashCode() : 0;
            result = 31 * result + (this.domainLimits != null ? this.domainLimits.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "NetworkConfig{defaultCaptureLimit=" + this.defaultCaptureLimit + ", domainLimits=" + this.domainLimits + '}';
        }
    }

    static class UiConfig {
        private final Integer breadcrumbs;
        private final Integer fragments;
        private final Integer taps;
        private final Integer views;
        @SerializedName(value="web_views")
        private final Integer webViews;

        UiConfig(Integer breadcrumbs, Integer taps, Integer views, Integer webViews, Integer fragments) {
            this.breadcrumbs = breadcrumbs;
            this.taps = taps;
            this.views = views;
            this.webViews = webViews;
            this.fragments = fragments;
        }

        public Optional<Integer> getBreadcrumbs() {
            return Optional.fromNullable((Object)this.breadcrumbs);
        }

        public Optional<Integer> getFragments() {
            return Optional.fromNullable((Object)this.fragments);
        }

        public Optional<Integer> getTaps() {
            return Optional.fromNullable((Object)this.taps);
        }

        public Optional<Integer> getViews() {
            return Optional.fromNullable((Object)this.views);
        }

        public Optional<Integer> getWebViews() {
            return Optional.fromNullable((Object)this.webViews);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UiConfig uiConfig = (UiConfig)o;
            if (this.breadcrumbs != null ? !this.breadcrumbs.equals(uiConfig.breadcrumbs) : uiConfig.breadcrumbs != null) {
                return false;
            }
            if (this.fragments != null ? !this.fragments.equals(uiConfig.fragments) : uiConfig.fragments != null) {
                return false;
            }
            if (this.taps != null ? !this.taps.equals(uiConfig.taps) : uiConfig.taps != null) {
                return false;
            }
            if (this.views != null ? !this.views.equals(uiConfig.views) : uiConfig.views != null) {
                return false;
            }
            return this.webViews != null ? this.webViews.equals(uiConfig.webViews) : uiConfig.webViews == null;
        }

        public int hashCode() {
            int result = this.breadcrumbs != null ? this.breadcrumbs.hashCode() : 0;
            result = 31 * result + (this.fragments != null ? this.fragments.hashCode() : 0);
            result = 31 * result + (this.taps != null ? this.taps.hashCode() : 0);
            result = 31 * result + (this.views != null ? this.views.hashCode() : 0);
            result = 31 * result + (this.webViews != null ? this.webViews.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "UiConfig{breadcrumbs=" + this.breadcrumbs + ", fragments=" + this.fragments + ", taps=" + this.taps + ", views=" + this.views + ", webViews=" + this.webViews + '}';
        }
    }
}

