package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

import java9.util.Lists;

class ThreadInfo {
    /**
     * The name of the thread.
     */
    @SerializedName("n")
    private final String name;

    /**
     * The priority of the thread
     */
    @SerializedName("p")
    private final int priority;

    /**
     * String representation of each line of the stack trace.
     */
    @SerializedName("tt")
    private final List<String> lines;

    ThreadInfo(String name, int priority, List<String> lines) {
        this.name = name;
        this.priority = priority;
        this.lines = Lists.copyOf(lines);
    }

    String getName() {
        return name;
    }

    int getPriority() {
        return priority;
    }

    List<String> getLines() {
        return lines;
    }

    /**
     * Creates a {@link ThreadInfo} from the {@link Thread}, {@link StackTraceElement}[] pair,
     * using the thread name and priority, and each stacktrace element as each line.
     *
     * @param thread the exception
     * @return the stacktrace instance
     */
    static ThreadInfo ofThread(Thread thread, StackTraceElement[] stackTraceElements) {
        String name = thread.getName();
        int priority = thread.getPriority();

        List<String> lines = new ArrayList<>();
        for (StackTraceElement line : stackTraceElements) {
            lines.add(line.toString());
        }

        return new ThreadInfo(name, priority, lines);
    }
}
