/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.util.Pair;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceAnrService;
import io.embrace.android.embracesdk.EmbraceBreadcrumbService;
import io.embrace.android.embracesdk.EmbraceCacheService;
import io.embrace.android.embracesdk.EmbraceConfigService;
import io.embrace.android.embracesdk.EmbraceConnectionClassService;
import io.embrace.android.embracesdk.EmbraceCpuService;
import io.embrace.android.embracesdk.EmbraceCrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceEventService;
import io.embrace.android.embracesdk.EmbraceExceptionService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceMemoryCleanerService;
import io.embrace.android.embracesdk.EmbraceMemoryService;
import io.embrace.android.embracesdk.EmbraceMetadataService;
import io.embrace.android.embracesdk.EmbraceNetworkConnectivityService;
import io.embrace.android.embracesdk.EmbraceNetworkLoggingService;
import io.embrace.android.embracesdk.EmbraceOrientationService;
import io.embrace.android.embracesdk.EmbracePerformanceInfoService;
import io.embrace.android.embracesdk.EmbracePowerService;
import io.embrace.android.embracesdk.EmbracePreferencesService;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceScreenshotService;
import io.embrace.android.embracesdk.EmbraceSessionService;
import io.embrace.android.embracesdk.EmbraceSignalQualityService;
import io.embrace.android.embracesdk.EmbraceUserService;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.JsException;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.OrientationService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SignalQualityService;
import io.embrace.android.embracesdk.StreamHandlerFactoryInstaller;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Embrace {
    private static final Embrace embrace = new Embrace();
    private static final String ERROR_NOT_INITIALIZED = "Embrace SDK is not initialized yet, cannot log event";
    private static final String ERROR_USER_UPDATES_DISABLED = "User updates are disabled, ignoring user persona update.";
    private volatile Application application;
    private volatile CacheService cacheService;
    private volatile CrashService crashService;
    private volatile BreadcrumbService breadcrumbService;
    private volatile EmbraceSessionService sessionService;
    private volatile MetadataService metadataService;
    private volatile PerformanceInfoService performanceInfoService;
    private volatile PowerService powerService;
    private volatile MemoryService memoryService;
    private volatile EmbraceActivityService activityService;
    private volatile NetworkConnectivityService networkConnectivityService;
    private volatile NetworkLoggingService networkLoggingService;
    private volatile CpuService cpuService;
    private volatile BuildInfo buildInfo;
    private volatile LocalConfig localConfig;
    private volatile AnrService anrService;
    private volatile EmbraceRemoteLogger remoteLogger;
    private volatile ConfigService configService;
    private volatile PreferencesService preferencesService;
    private volatile ScreenshotService screenshotService;
    private volatile EventService eventService;
    private volatile UserService userService;
    private volatile SignalQualityService signalQualityService;
    private volatile EmbraceExceptionService exceptionsService;
    private volatile MemoryCleanerService memoryCleanerService;
    private volatile OrientationService orientationService;
    private volatile AtomicBoolean started = new AtomicBoolean(false);

    public static Embrace getInstance() {
        return embrace;
    }

    public void start(Context context) {
        this.start(context, true, AppFramework.NATIVE);
    }

    public void start(Context context, boolean enableIntegrationTesting) {
        this.start(context, enableIntegrationTesting, AppFramework.NATIVE);
    }

    public void start(Context context, boolean enableIntegrationTesting, AppFramework appFramework) {
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("To initialize EmbraceSDK, please use the Application's context.");
        }
        this.start((Application)context, enableIntegrationTesting, appFramework);
    }

    public void start(Application application) {
        this.start(application, true, AppFramework.NATIVE);
    }

    public void start(Application application, boolean enableIntegrationTesting) {
        this.start(application, enableIntegrationTesting, AppFramework.NATIVE);
    }

    public void start(Application application, boolean enableIntegrationTesting, AppFramework appFramework) {
        if (this.application != null) {
            EmbraceLogger.logWarning("Embrace SDK has already been initialized");
            return;
        }
        this.application = (Application)Preconditions.checkNotNull((Object)application, (Object)"application must not be null");
        Context context = this.application.getApplicationContext();
        try {
            this.memoryCleanerService = new EmbraceMemoryCleanerService();
            this.powerService = new EmbracePowerService(context, this.memoryCleanerService);
            this.memoryService = EmbraceMemoryService.ofContext(context, this.memoryCleanerService);
            this.orientationService = new EmbraceOrientationService(this.memoryCleanerService);
            this.activityService = new EmbraceActivityService(application, this.memoryService, this.orientationService);
            this.exceptionsService = new EmbraceExceptionService(this.activityService);
            this.preferencesService = new EmbracePreferencesService(context, this.activityService);
            this.networkConnectivityService = new EmbraceNetworkConnectivityService(context, this.memoryCleanerService);
            this.cpuService = new EmbraceCpuService();
            this.anrService = new EmbraceAnrService(this.memoryCleanerService);
            this.buildInfo = BuildInfo.fromResources(context);
            this.localConfig = LocalConfig.fromResources(context);
            this.metadataService = EmbraceMetadataService.ofContext(context, this.buildInfo, this.localConfig, appFramework, this.preferencesService, this.activityService);
            EmbraceConnectionClassService connectionClassService = new EmbraceConnectionClassService(this.memoryCleanerService);
            this.cacheService = new EmbraceCacheService(context);
            ApiClient apiClient = new ApiClient(this.localConfig, this.metadataService, this.cacheService, enableIntegrationTesting);
            this.configService = new EmbraceConfigService(apiClient, this.activityService, this.cacheService, this.metadataService);
            this.exceptionsService.setConfigService(this.configService);
            this.signalQualityService = new EmbraceSignalQualityService(context, this.configService, this.activityService, connectionClassService, this.memoryCleanerService);
            this.breadcrumbService = new EmbraceBreadcrumbService(this.configService, this.localConfig, this.activityService, this.memoryCleanerService);
            if (this.configService.isSdkDisabled()) {
                this.stop();
                return;
            }
            this.userService = new EmbraceUserService(this.preferencesService);
            this.screenshotService = new EmbraceScreenshotService(this.activityService, this.configService, apiClient);
            this.networkLoggingService = new EmbraceNetworkLoggingService(connectionClassService, this.configService, this.localConfig, this.memoryCleanerService);
            this.performanceInfoService = new EmbracePerformanceInfoService(this.anrService, this.networkConnectivityService, this.networkLoggingService, this.powerService, this.cpuService, this.memoryService, this.signalQualityService, connectionClassService, this.metadataService);
            this.eventService = new EmbraceEventService(apiClient, this.configService, this.localConfig, this.metadataService, this.performanceInfoService, this.userService, this.screenshotService, this.activityService, this.memoryCleanerService);
            this.remoteLogger = new EmbraceRemoteLogger(this.metadataService, this.screenshotService, apiClient, this.userService, this.configService, this.memoryCleanerService);
            this.sessionService = new EmbraceSessionService(this.preferencesService, this.performanceInfoService, this.metadataService, this.breadcrumbService, this.powerService, this.activityService, apiClient, this.eventService, this.remoteLogger, this.userService, this.configService, this.cacheService, this.exceptionsService, this.localConfig, this.memoryCleanerService, this.orientationService);
            this.crashService = new EmbraceCrashService(this.localConfig, this.sessionService, this.metadataService, apiClient, this.userService, this.eventService);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Exception occurred while initializing the Embrace SDK. Instrumentation may be disabled.", ex, true);
            return;
        }
        EmbraceLogger.logInfo(String.format("Embrace SDK started. Version: %s", "4.0.0-beta7"));
        StreamHandlerFactoryInstaller.registerFactory(this.localConfig.getConfigurations().getNetworking().getCaptureRequestContentLength());
        this.started.set(true);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    void stop() {
        if (this.started.compareAndSet(true, false)) {
            EmbraceLogger.logInfo("Shutting down Embrace SDK.");
            try {
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.powerService != null) {
                    this.powerService.close();
                }
                if (this.memoryService != null) {
                    this.memoryService.close();
                }
                if (this.cpuService != null) {
                    this.cpuService.close();
                }
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.activityService != null) {
                    this.activityService.close();
                }
                if (this.sessionService != null) {
                    this.sessionService.close();
                }
                if (this.eventService != null) {
                    this.eventService.close();
                }
                if (this.networkConnectivityService != null) {
                    this.networkConnectivityService.close();
                }
                if (this.signalQualityService != null) {
                    this.signalQualityService.close();
                }
                this.memoryCleanerService = null;
                this.powerService = null;
                this.memoryService = null;
                this.breadcrumbService = null;
                this.activityService = null;
                this.preferencesService = null;
                this.networkConnectivityService = null;
                this.cpuService = null;
                this.anrService = null;
                this.buildInfo = null;
                this.localConfig = null;
                this.metadataService = null;
                this.performanceInfoService = null;
                this.cacheService = null;
                this.userService = null;
                this.screenshotService = null;
                this.eventService = null;
                this.remoteLogger = null;
                this.sessionService = null;
                this.crashService = null;
                this.signalQualityService = null;
                this.networkLoggingService = null;
                this.application = null;
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Error while shutting down Embrace SDK", ex);
            }
        }
    }

    @Deprecated
    public void setLogLevel(EmbraceLogger.Severity severity) {
    }

    public void setUserIdentifier(String userId) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.setUserIdentifier(userId);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user identifier");
        }
    }

    public void clearUserIdentifier() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.clearUserIdentifier();
        }
    }

    public void setUserEmail(String email) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.setUserEmail(email);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user identifier");
        }
    }

    public void clearUserEmail() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.clearUserEmail();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user email");
        }
    }

    public void setUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.setUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user as payer");
        }
    }

    public void clearUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.clearUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user as payer");
        }
    }

    public void setUserPersona(String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.setUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user persona");
        }
    }

    public void clearUserPersona(String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user persona");
        }
    }

    public void clearAllUserPersonas() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearAllUserPersonas();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user personas");
        }
    }

    public void setUsername(String username) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.setUsername(username);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set username");
        }
    }

    public void clearUsername() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.clearUsername();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear username");
        }
    }

    public void startEvent(String name) {
        if (this.isStarted()) {
            this.eventService.startEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(String name, String identifier) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier);
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(String name, String identifier, Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot, Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name) {
        if (this.isStarted()) {
            this.eventService.endEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name, String identifier) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name, Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name, String identifier, Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier, this.normalizeProperties(properties));
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endAppStartup() {
        this.endEvent("_startup");
    }

    public void endAppStartup(Map<String, Object> properties) {
        this.endEvent("_startup", null, properties);
    }

    public String getTraceIdHeader() {
        return this.isStarted() ? this.localConfig.getConfigurations().getNetworking().getTraceIdHeader() : "x-emb-trace-id";
    }

    public void logNetworkRequest(EmbraceNetworkRequest request) {
        if (this.isStarted()) {
            if (request == null) {
                return;
            }
            if (!request.canSend()) {
                return;
            }
            if (request.getError() != null) {
                this.networkLoggingService.logNetworkError(request.getUrl(), request.getHttpMethod(), request.getStartTime(), request.getEndTime(), request.getError().getClass().getCanonicalName(), request.getError().getLocalizedMessage(), request.getTraceId());
            } else {
                this.networkLoggingService.logNetworkCall(request.getUrl(), request.getHttpMethod(), request.getResponseCode(), request.getStartTime(), request.getEndTime(), request.getBytesIn(), request.getBytesOut(), request.getTraceId());
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network request");
        }
    }

    public void logNetworkCall(String url, HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        this.logNetworkCall(url, httpMethod, statusCode, startTime, endTime, bytesSent, bytesReceived, null);
    }

    public void logNetworkCall(String url, HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived, String traceId) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkCall(url, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived, traceId);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network call");
        }
    }

    public void logNetworkClientError(String url, HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        this.logNetworkClientError(url, httpMethod, startTime, endTime, errorType, errorMessage, null);
    }

    public void logNetworkClientError(String url, HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage, String traceId) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkError(url, httpMethod.name(), startTime, endTime, errorType, errorMessage, traceId);
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot log network error");
        }
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.INFO_LOG, message, properties, false, null, null);
    }

    public void logWarning(String message) {
        this.logWarning(message, null, false, null);
    }

    public void logWarning(String message, Map<String, Object> properties) {
        this.logWarning(message, properties, false, null);
    }

    public void logWarning(String message, Map<String, Object> properties, Boolean allowScreenshot) {
        this.logWarning(message, properties, allowScreenshot, null);
    }

    public void logWarning(String message, Map<String, Object> properties, Boolean allowScreenshot, String javascriptStackTrace) {
        this.logMessage(EmbraceEvent.Type.WARNING_LOG, message, properties, allowScreenshot, null, javascriptStackTrace);
    }

    public void logError(String message) {
        this.logError(message, null, true, null);
    }

    public void logError(String message, Map<String, Object> properties) {
        this.logError(message, properties, true, null);
    }

    public void logError(String message, Map<String, Object> properties, boolean allowScreenshot) {
        this.logError(message, properties, allowScreenshot, null);
    }

    public void logError(String message, Map<String, Object> properties, boolean allowScreenshot, String javascriptStackTrace) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot, null, javascriptStackTrace);
    }

    public void logError(Throwable e) {
        this.logError(e, null, false);
    }

    public void logError(Throwable e, Map<String, Object> properties) {
        this.logError(e, properties, false);
    }

    public void logError(Throwable e, Map<String, Object> properties, boolean allowScreenshot) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, e.getLocalizedMessage(), properties, allowScreenshot, e.getStackTrace(), null);
    }

    void logMessage(EmbraceEvent.Type type, String message, Map<String, Object> properties, boolean allowScreenshot, StackTraceElement[] stackTraceElements, String javascriptStackTrace) {
        if (this.isStarted()) {
            try {
                this.remoteLogger.log(message, type, allowScreenshot, this.normalizeProperties(properties), stackTraceElements, javascriptStackTrace);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to log message using Embrace SDK.", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log message.");
        }
    }

    public void logBreadcrumb(String message) {
        if (this.isStarted()) {
            this.breadcrumbService.logCustom(message, System.currentTimeMillis());
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log breadcrumb.");
        }
    }

    public void logUnhandledJsException(String name, String message, String type, String stacktrace) {
        if (this.isStarted()) {
            JsException exception = new JsException(name, message, type, stacktrace);
            this.crashService.logUnhandledJsException(exception);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log JS exception.");
        }
    }

    public void setReactNativeVersionNumber(String version) {
        if (this.isStarted()) {
            if (version == null) {
                EmbraceLogger.logError("ReactNative version must not be null");
                return;
            }
            if (version.isEmpty()) {
                EmbraceLogger.logError("ReactNative version must have non-zero length");
                return;
            }
            this.preferencesService.setReactNativeVersionNumber(version);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set React Native version number.");
        }
    }

    public void setJavaScriptPatchNumber(String number) {
        if (this.isStarted()) {
            if (number == null) {
                EmbraceLogger.logError("JavaScript patch number must not be null");
                return;
            }
            if (number.isEmpty()) {
                EmbraceLogger.logError("JavaScript patch number must have non-zero length");
                return;
            }
            this.preferencesService.setJavaScriptPatchNumber(number);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set JavaScript patch number.");
        }
    }

    public void setJavaScriptBundleURL(String url) {
        if (this.isStarted()) {
            String currentUrl;
            if (url == null) {
                EmbraceLogger.logError("JavaScript bundle URL must not be null");
                return;
            }
            if (url.isEmpty()) {
                EmbraceLogger.logError("JavaScript bundle URL must have non-zero length");
                return;
            }
            if (this.preferencesService.getJavaScriptBundleURL().isPresent() && url.equals(currentUrl = (String)this.preferencesService.getJavaScriptBundleURL().get())) {
                return;
            }
            this.preferencesService.setJavaScriptBundleURL(url);
        } else {
            EmbraceLogger.logError("Embrace SDK is not initialized yet, cannot set JavaScript bundle URL.");
        }
    }

    public void addConnectionQualityListener(ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.addListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to add connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot add listener.");
        }
    }

    public void removeConnectionQualityListener(ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.removeListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to remove connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot remove listener.");
        }
    }

    public synchronized void endSession() {
        this.endSession(false);
    }

    public synchronized void endSession(boolean clearUserInfo) {
        if (this.isStarted()) {
            if (this.localConfig.getConfigurations().getSessionConfig().getMaxSessionSeconds().isPresent()) {
                EmbraceLogger.logWarning("Can't close the session, automatic session close enabled.");
                return;
            }
            if (clearUserInfo) {
                this.userService.clearUserInfo();
            }
            this.sessionService.triggerStatelessSessionEnd(Session.SessionLifeEventType.MANUAL);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot end session.");
        }
    }

    public String getDeviceId() {
        return (String)this.preferencesService.getDeviceIdentifier().orNull();
    }

    public void throwException() {
        throw new RuntimeException("EmbraceException", new Throwable("Embrace test exception"));
    }

    void logView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.logView(screen, System.currentTimeMillis());
        }
    }

    void logWebView(String url) {
        if (this.isStarted()) {
            this.breadcrumbService.logWebView(url, System.currentTimeMillis());
        }
    }

    void forceLogView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.forceLogView(screen, System.currentTimeMillis());
        }
    }

    void logTap(Pair<Float, Float> point, String elementName, TapBreadcrumb.TapBreadcrumbType type) {
        if (this.isStarted()) {
            this.breadcrumbService.logTap(point, elementName, System.currentTimeMillis(), type);
        }
    }

    EventService getEventService() {
        return this.eventService;
    }

    EmbraceRemoteLogger getRemoteLogger() {
        return this.remoteLogger;
    }

    EmbraceExceptionService getExceptionsService() {
        return this.exceptionsService;
    }

    MetadataService getMetadataService() {
        return this.metadataService;
    }

    EmbraceSessionService getSessionService() {
        return this.sessionService;
    }

    private Map<String, Object> normalizeProperties(Map<String, Object> properties) {
        Map<String, Object> normalizedProperties = new HashMap<String, Object>();
        if (properties != null) {
            try {
                normalizedProperties = PropertyUtils.sanitizeProperties(properties);
            }
            catch (Exception e) {
                EmbraceLogger.logError("Exception occurred while normalizing the properties.", e, true);
            }
        }
        return normalizedProperties;
    }

    public static enum AppFramework {
        NATIVE(1),
        REACT_NATIVE(2);

        private int value;

        private AppFramework(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

