/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryCleanerListener;
import io.embrace.android.embracesdk.MemoryCleanerService;
import java.util.concurrent.CopyOnWriteArrayList;
import java9.util.stream.StreamSupport;

final class EmbraceMemoryCleanerService
implements MemoryCleanerService {
    private static final String ERROR_FAILED_TO_CLEAN = "Failed to clean collections on service listener";
    private final CopyOnWriteArrayList<MemoryCleanerListener> listeners = new CopyOnWriteArrayList();

    EmbraceMemoryCleanerService() {
    }

    @Override
    public void cleanServicesCollections() {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.cleanCollections();
                Embrace.getInstance().getMetadataService().setActiveSessionId(null);
                Embrace.getInstance().getExceptionsService().resetExceptionErrorObject();
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug(ERROR_FAILED_TO_CLEAN, ex);
            }
        });
    }

    @Override
    public void addListener(MemoryCleanerListener listener) {
        this.listeners.addIfAbsent(listener);
    }
}

