/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network;

import android.net.Uri;
import android.webkit.URLUtil;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.EnumSet;
import java.util.Locale;

public class EmbraceNetworkRequest {
    private static EnumSet<HttpMethod> allowedMethods = EnumSet.of(HttpMethod.GET, HttpMethod.PUT, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PATCH);
    private String url;
    private HttpMethod httpMethod;
    private Long startTime;
    private Long endTime;
    private Long bytesIn;
    private Long bytesOut;
    private Integer responseCode;
    private Throwable error;
    private String traceId;

    private EmbraceNetworkRequest(Builder builder) {
        this.url = builder.urlString;
        this.httpMethod = builder.httpMethod;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.bytesIn = builder.bytesIn;
        this.bytesOut = builder.bytesOut;
        this.responseCode = builder.responseCode;
        this.error = builder.error;
        this.traceId = builder.traceId;
    }

    private static boolean validateMethod(HttpMethod method) {
        if (method == null) {
            EmbraceLogger.logError("Method cannot be null");
            return false;
        }
        if (!allowedMethods.contains((Object)method)) {
            EmbraceLogger.logError(String.format("Not a valid method: %s", method.name()));
            return false;
        }
        return true;
    }

    public boolean canSend() {
        if (this.url == null) {
            EmbraceLogger.logError("Request must contain URL");
            return false;
        }
        if (this.httpMethod == null) {
            EmbraceLogger.logError("Request must contain method");
            return false;
        }
        if (this.startTime == null) {
            EmbraceLogger.logError("Request must contain startTime");
            return false;
        }
        if (this.endTime == null) {
            EmbraceLogger.logError("Request must contain endTime");
            return false;
        }
        if ((this.responseCode == null || this.responseCode == -1) && this.error == null) {
            EmbraceLogger.logError("Request must either have responseCode or error set");
            return false;
        }
        return true;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod != null ? this.httpMethod.name().toUpperCase() : null;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getBytesIn() {
        return this.bytesIn == null ? 0L : this.bytesIn;
    }

    public Long getBytesOut() {
        return this.bytesOut == null ? 0L : this.bytesOut;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public Throwable getError() {
        return this.error;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String description() {
        return String.format("<%s: %s URL = %s Method = %s Start = %s>", new Object[]{this, this, this.url, this.httpMethod, this.startTime});
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String urlString;
        private HttpMethod httpMethod;
        private Long startTime;
        private Long endTime;
        private Long bytesIn;
        private Long bytesOut;
        private Integer responseCode;
        private Throwable error;
        private String traceId;

        private Builder() {
        }

        public void withUrl(String urlString) {
            this.urlString = urlString;
        }

        public void withHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        public void withStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public void withEndTime(Long date) {
            if (date == null) {
                EmbraceLogger.logError("End time cannot be null");
                return;
            }
            if (date <= this.startTime) {
                EmbraceLogger.logError("End time cannot be before the start time");
                return;
            }
            this.endTime = date;
        }

        @Deprecated
        public void withByteIn(Long bytesIn) {
            this.withBytesIn(bytesIn);
        }

        public void withBytesIn(Long bytesIn) {
            if (bytesIn == null) {
                EmbraceLogger.logError("BytesIn cannot be null");
                return;
            }
            if (bytesIn < 0L) {
                EmbraceLogger.logError("BytesIn must be a positive long");
                return;
            }
            this.bytesIn = bytesIn;
        }

        @Deprecated
        public void withByteOut(Long bytesOut) {
            this.withBytesOut(bytesOut);
        }

        public void withBytesOut(Long bytesOut) {
            if (bytesOut == null) {
                EmbraceLogger.logError("BytesOut cannot be null");
                return;
            }
            if (bytesOut < 0L) {
                EmbraceLogger.logError("BytesOut must be a positive long");
                return;
            }
            this.bytesOut = bytesOut;
        }

        public void withResponseCode(Integer responseCode) {
            if (responseCode < 100 || responseCode > 599) {
                EmbraceLogger.logError(String.format(Locale.getDefault(), "Invalid responseCode: %d", responseCode));
                return;
            }
            this.responseCode = responseCode;
        }

        public void withError(Throwable error) {
            if (error == null) {
                EmbraceLogger.logError("Ignoring null error");
                return;
            }
            this.error = error;
        }

        public void withTraceId(String traceId) {
            this.traceId = traceId;
        }

        public EmbraceNetworkRequest build() {
            Uri url;
            try {
                url = Uri.parse((String)this.urlString);
            }
            catch (NullPointerException ex) {
                EmbraceLogger.logError(String.format("Invalid URL: %s", this.urlString));
                return null;
            }
            if (url == null || url.getScheme() == null || url.getHost() == null) {
                EmbraceLogger.logError(String.format("Invalid URL: %s", this.urlString));
                return null;
            }
            if (!URLUtil.isHttpsUrl((String)this.urlString) && !URLUtil.isHttpUrl((String)this.urlString)) {
                EmbraceLogger.logError(String.format("Only http and https schemes are supported: %s", this.urlString));
                return null;
            }
            if (!EmbraceNetworkRequest.validateMethod(this.httpMethod)) {
                return null;
            }
            if (this.startTime == null) {
                EmbraceLogger.logError("Start time cannot be null");
                return null;
            }
            return new EmbraceNetworkRequest(this);
        }
    }
}

