/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.ConnectionClassService;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.EventPerformanceInfo;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.PerformanceInfo;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.SessionPerformanceInfo;
import io.embrace.android.embracesdk.SignalQualityService;

final class EmbracePerformanceInfoService
implements PerformanceInfoService {
    private final AnrService anrService;
    private final NetworkConnectivityService networkConnectivityService;
    private final NetworkLoggingService networkLoggingService;
    private final PowerService powerService;
    private final CpuService cpuService;
    private final MemoryService memoryService;
    private final SignalQualityService signalQualityService;
    private final ConnectionClassService connectionClassService;
    private final MetadataService metadataService;

    EmbracePerformanceInfoService(AnrService anrService, NetworkConnectivityService networkConnectivityService, NetworkLoggingService networkLoggingService, PowerService powerService, CpuService cpuService, MemoryService memoryService, SignalQualityService signalQualityService, ConnectionClassService connectionClassService, MetadataService metadataService) {
        this.anrService = (AnrService)Preconditions.checkNotNull((Object)anrService);
        this.networkConnectivityService = (NetworkConnectivityService)Preconditions.checkNotNull((Object)networkConnectivityService);
        this.networkLoggingService = (NetworkLoggingService)Preconditions.checkNotNull((Object)networkLoggingService);
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.cpuService = (CpuService)Preconditions.checkNotNull((Object)cpuService);
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.signalQualityService = (SignalQualityService)Preconditions.checkNotNull((Object)signalQualityService);
        this.connectionClassService = (ConnectionClassService)Preconditions.checkNotNull((Object)connectionClassService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
    }

    @Override
    public SessionPerformanceInfo getSessionPerformanceInfo(long startTime, long lastKnownTime) {
        SessionPerformanceInfo.Builder builder = SessionPerformanceInfo.newBuilder().withNetworkSessionV2(this.networkLoggingService.getNetworkSession(startTime, lastKnownTime));
        builder.withAnrIntervals(this.anrService.getAnrIntervals(startTime, lastKnownTime));
        this.addPerformanceInfo(builder, startTime, lastKnownTime);
        return builder.build();
    }

    @Override
    public EventPerformanceInfo getPerformanceInfo(long startTime, long endTime) {
        EventPerformanceInfo.Builder builder = EventPerformanceInfo.newBuilder().withNetworkCalls(this.networkLoggingService.getNetworkCalls(startTime, endTime));
        this.addPerformanceInfo(builder, startTime, endTime);
        return builder.build();
    }

    private <T extends PerformanceInfo.Builder> void addPerformanceInfo(T builder, long startTime, long endTime) {
        builder.withBatteryMeasurements(this.powerService.getBatteryMeasurements(startTime, endTime)).withChargingIntervals(this.powerService.getChargingIntervals(startTime, endTime)).withCriticalCpuIntervals(this.cpuService.getCpuCriticalIntervals(startTime, endTime)).withDiskUsage(this.metadataService.getDiskUsage()).withMemorySamples(this.memoryService.getMemorySamples(startTime, endTime)).withMemoryWarnings(this.memoryService.getMemoryWarnings(startTime, endTime)).withNetworkInterfaceIntervals(this.networkConnectivityService.getNetworkInterfaceIntervals(startTime, endTime)).withSignalStrength(this.signalQualityService.getSignalMeasurements(startTime, endTime)).withConnectionQualityIntervals(this.connectionClassService.getQualityIntervals(startTime, endTime));
        if (this.powerService.getLatestBatteryLevel().isPresent()) {
            builder.withBatteryLevel(((Float)this.powerService.getLatestBatteryLevel().get()).floatValue());
        }
    }
}

