/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Log;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.Embrace;

public class EmbraceLogger {
    private static Severity threshold = Severity.INFO;

    private EmbraceLogger() {
    }

    public static void setThreshold(Severity threshold) {
        EmbraceLogger.threshold = (Severity)((Object)Preconditions.checkNotNull((Object)((Object)threshold), (Object)"threshold must not be null"));
    }

    public static void logDebug(String msg) {
        EmbraceLogger.log(Severity.DEBUG, msg, null, false);
    }

    public static void logDebug(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.DEBUG, msg, throwable, false);
    }

    public static void logDebug(String msg, Throwable throwable, Boolean logStacktrace) {
        EmbraceLogger.log(Severity.DEBUG, msg, throwable, logStacktrace);
    }

    public static void logInfo(String msg) {
        EmbraceLogger.log(Severity.INFO, msg, null, false);
    }

    public static void logInfo(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.INFO, msg, throwable, false);
    }

    public static void logInfo(String msg, Throwable throwable, Boolean logStacktrace) {
        EmbraceLogger.log(Severity.INFO, msg, throwable, logStacktrace);
    }

    public static void logWarning(String msg) {
        EmbraceLogger.log(Severity.WARNING, msg, null, false);
    }

    public static void logWarning(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.WARNING, msg, throwable, false);
    }

    public static void logWarning(String msg, Throwable throwable, Boolean logStacktrace) {
        EmbraceLogger.log(Severity.WARNING, msg, throwable, logStacktrace);
    }

    public static void logError(String msg) {
        EmbraceLogger.log(Severity.ERROR, msg, null, false);
    }

    public static void logError(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.ERROR, msg, throwable, false);
    }

    public static void logError(String msg, Throwable throwable, Boolean logStacktrace) {
        EmbraceLogger.log(Severity.ERROR, msg, throwable, logStacktrace);
    }

    public static void log(Severity severity, String msg, Throwable throwable, boolean logStacktrace) {
        if (severity == null) {
            throw new IllegalArgumentException("Severity is null or blank.");
        }
        if (msg == null) {
            msg = "";
        }
        if (severity.ordinal() >= threshold.ordinal()) {
            if (logStacktrace) {
                Log.e((String)"[Embrace]", (String)String.format("%s", msg), (Throwable)throwable);
            } else {
                Log.e((String)"[Embrace", (String)String.format("%s", msg));
            }
        }
        if (throwable != null) {
            try {
                Embrace.getInstance().getExceptionsService().handleExceptionError(throwable);
            }
            catch (Exception e) {
                Log.e((String)"[Embrace]", (String)e.getLocalizedMessage());
            }
        }
    }

    public static enum Severity {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        NONE;

    }
}

