package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

/**
 * Describes an Exception Error with a count of occurrences and a list of exceptions (causes).
 */
final class ExceptionError {

    /**
     * The occurrences list limit.
     */
    private static final int DEFAULT_EXCEPTION_ERROR_LIMIT = 5;

    @SerializedName("c")
    private int occurrences;

    @SerializedName("rep")
    private List<ExceptionErrorInfo> exceptionErrors;

    ExceptionError() {
        this.occurrences = 0;
        this.exceptionErrors = new ArrayList<>();
    }

    /**
     * Add a new exception error info if exceptionErrors's size is below 20.
     * For each exceptions, occurrences is incremented by 1.
     *
     * @param ex fo the exception error.
     * @param appState (foreground or background).
     */
    void addException(Throwable ex, String appState) {
        occurrences++;
        if (exceptionErrors.size() < DEFAULT_EXCEPTION_ERROR_LIMIT) {
            exceptionErrors.add(new
                    ExceptionErrorInfo(
                    System.currentTimeMillis(),
                    appState,
                    exceptionInfo(ex)
            ));
        }
    }

    private List<ExceptionInfo> exceptionInfo(Throwable ex) {
        List<ExceptionInfo> result = new ArrayList<>();
        Throwable throwable = ex;
        while (throwable != null && !throwable.equals(throwable.getCause())) {
            ExceptionInfo exceptionInfo = ExceptionInfo.ofThrowable(throwable);
            result.add(0, exceptionInfo);
            throwable = throwable.getCause();
        }
        return result;
    }
}
