/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

final class LocalConfig {
    private static final String FILE_LOCAL_CONFIG = "embrace-config.json";
    @SerializedName(value="app_id")
    private final String appId;
    @SerializedName(value="base_urls")
    private final BaseUrls baseUrls;
    @SerializedName(value="crash_handler")
    private final CrashHandler crashHandler;
    @SerializedName(value="startup_moment")
    private final StartupMoment startupMoment;
    @SerializedName(value="networking")
    private final Networking networking;
    @SerializedName(value="session")
    private final SessionConfig sessionConfig;
    @SerializedName(value="taps")
    private final Taps taps;

    LocalConfig() {
        this(null, null, null, null, null, null, null);
    }

    private LocalConfig(String appId, BaseUrls baseUrls, CrashHandler crashHandler, StartupMoment startupMoment, Networking networking, SessionConfig sessionConfig, Taps taps) {
        this.appId = (String)Optional.fromNullable((Object)appId).orNull();
        this.baseUrls = (BaseUrls)Optional.fromNullable((Object)baseUrls).or((Object)new BaseUrls());
        this.crashHandler = (CrashHandler)Optional.fromNullable((Object)crashHandler).or((Object)new CrashHandler());
        this.startupMoment = (StartupMoment)Optional.fromNullable((Object)startupMoment).or((Object)new StartupMoment());
        this.networking = (Networking)Optional.fromNullable((Object)networking).or((Object)new Networking());
        this.sessionConfig = (SessionConfig)Optional.fromNullable((Object)sessionConfig).or((Object)new SessionConfig());
        this.taps = (Taps)Optional.fromNullable((Object)taps).or((Object)new Taps());
    }

    BaseUrls getBaseUrls() {
        return this.baseUrls;
    }

    CrashHandler getCrashHandler() {
        return this.crashHandler;
    }

    StartupMoment getStartupMoment() {
        return this.startupMoment;
    }

    Networking getNetworking() {
        return this.networking;
    }

    SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    String getAppId() {
        return this.appId;
    }

    Taps getTaps() {
        return this.taps;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LocalConfig fromFile(Context context) {
        try (InputStream inputStream = context.getApplicationContext().getAssets().open(FILE_LOCAL_CONFIG);){
            LocalConfig localConfig = LocalConfig.fromInputStream(inputStream);
            return localConfig;
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("Embrace config file embrace-config.json does not exist");
            return new LocalConfig();
        }
    }

    /*
     * Exception decompiling
     */
    static LocalConfig fromInputStream(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class Taps {
        static final Boolean CAPTURE_COORDINATES_DEFAULT = true;
        @SerializedName(value="capture_coordinates")
        private Boolean captureCoordinates;

        Taps() {
            this(null);
        }

        Taps(Boolean captureCoordinates) {
            this.captureCoordinates = (Boolean)Optional.fromNullable((Object)captureCoordinates).or((Object)CAPTURE_COORDINATES_DEFAULT);
        }

        Boolean getCaptureCoordinates() {
            return this.captureCoordinates;
        }
    }

    class SessionConfig {
        @SerializedName(value="max_session_seconds")
        private Integer maxSessionSeconds;

        SessionConfig() {
            this(null);
        }

        SessionConfig(Integer maxSessionSeconds) {
            this.maxSessionSeconds = maxSessionSeconds;
        }

        Optional<Integer> getMaxSessionSeconds() {
            return Optional.fromNullable((Object)this.maxSessionSeconds);
        }
    }

    static class Networking {
        static final String CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE = "x-emb-trace-id";
        @SerializedName(value="trace_id_header")
        private String traceIdHeader;
        @SerializedName(value="default_capture_limit")
        private final Integer defaultCaptureLimit;
        @SerializedName(value="domains")
        private final List<Domain> domains;

        Networking() {
            this(null, null, null);
        }

        Networking(String traceIdHeader, Integer defaultCaptureLimit, List<Domain> domains) {
            this.traceIdHeader = (String)Optional.fromNullable((Object)traceIdHeader).or((Object)CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE);
            this.defaultCaptureLimit = defaultCaptureLimit;
            this.domains = domains;
        }

        String getTraceIdHeader() {
            return this.traceIdHeader;
        }

        public Optional<Integer> getDefaultCaptureLimit() {
            return Optional.fromNullable((Object)this.defaultCaptureLimit);
        }

        public List<Domain> getDomains() {
            return this.domains != null ? this.domains : Collections.emptyList();
        }

        class Domain {
            @SerializedName(value="domain_name")
            private final String domain;
            @SerializedName(value="domain_limit")
            private final Integer limit;

            Domain(String domain, Integer limit) {
                this.domain = domain;
                this.limit = limit;
            }

            public String getDomain() {
                return this.domain;
            }

            public Integer getLimit() {
                return this.limit;
            }
        }
    }

    static class StartupMoment {
        static final Boolean AUTOMATICALLY_END_DEFAULT = true;
        static final Boolean TAKE_SCREENSHOT_DEFAULT = true;
        @SerializedName(value="automatically_end")
        private Boolean automaticallyEnd;
        @SerializedName(value="take_screenshot")
        private Boolean takeScreenshot;

        StartupMoment() {
            this(null, null);
        }

        StartupMoment(Boolean automaticallyEnd, Boolean takeScreenshot) {
            this.automaticallyEnd = (Boolean)Optional.fromNullable((Object)automaticallyEnd).or((Object)AUTOMATICALLY_END_DEFAULT);
            this.takeScreenshot = (Boolean)Optional.fromNullable((Object)takeScreenshot).or((Object)TAKE_SCREENSHOT_DEFAULT);
        }

        Boolean getAutomaticallyEnd() {
            return this.automaticallyEnd;
        }

        Boolean getTakeScreenshot() {
            return this.takeScreenshot;
        }
    }

    static class CrashHandler {
        static final Boolean ENABLED_DEFAULT = true;
        @SerializedName(value="enabled")
        private Boolean enabled;

        CrashHandler() {
            this(null);
        }

        CrashHandler(Boolean enabled) {
            this.enabled = (Boolean)Optional.fromNullable((Object)enabled).or((Object)ENABLED_DEFAULT);
        }

        Boolean getEnabled() {
            return this.enabled;
        }
    }

    static class BaseUrls {
        static final String CONFIG_DEFAULT = "https://config.emb-api.com";
        static final String DATA_DEFAULT = "https://data.emb-api.com";
        static final String DATA_DEV_DEFAULT = "https://data-dev.emb-api.com";
        static final String IMAGES_DEFAULT = "https://images.emb-api.com";
        @SerializedName(value="data")
        private String data;
        @SerializedName(value="data_dev")
        private String dataDev;
        @SerializedName(value="config")
        private String config;
        @SerializedName(value="images")
        private String images;

        BaseUrls() {
            this(null, null, null, null);
        }

        BaseUrls(String config, String data, String dataDev, String images) {
            this.config = (String)Optional.fromNullable((Object)config).or((Object)CONFIG_DEFAULT);
            this.data = (String)Optional.fromNullable((Object)data).or((Object)DATA_DEFAULT);
            this.dataDev = (String)Optional.fromNullable((Object)dataDev).or((Object)DATA_DEV_DEFAULT);
            this.images = (String)Optional.fromNullable((Object)images).or((Object)IMAGES_DEFAULT);
        }

        String getConfig() {
            return this.config;
        }

        String getData() {
            return this.data;
        }

        String getDataDev() {
            return this.dataDev;
        }

        String getImages() {
            return this.images;
        }
    }
}

