/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BackgroundWorker;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceExceptionService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.OrientationService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.util.concurrent.TimeUnit;

final class EmbraceSessionService
implements SessionService,
ActivityListener {
    public static final String APPLICATION_STATE_ACTIVE = "active";
    public static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String SESSION_START_TYPE = "st";
    private static final String SESSION_END_TYPE = "en";
    private static final String SESSION_FILE_NAME = "last_session.json";
    private static final int SESSION_CACHING_INTERVAL = 2;
    private static final int SEND_SESSION_API_CLIENT_TIMEOUT = 2;
    private final Object lock = new Object();
    private final PreferencesService preferencesService;
    private final PerformanceInfoService performanceInfoService;
    private final MetadataService metadataService;
    private final BreadcrumbService breadcrumbService;
    private final PowerService powerService;
    private final ActivityService activityService;
    private final ApiClient apiClient;
    private final EventService eventService;
    private final EmbraceRemoteLogger remoteLogger;
    private final UserService userService;
    private final ConfigService configService;
    private final CacheService cacheService;
    private final EmbraceExceptionService exceptionService;
    private final LocalConfig localConfig;
    private final MemoryCleanerService memoryCleanerService;
    private final OrientationService orientationService;
    private final BackgroundWorker sessionBackgroundWorker;
    private volatile ScheduledWorker sessionCacheWorker;
    private volatile ScheduledWorker automaticSessionCloser;
    private volatile Session activeSession;

    EmbraceSessionService(PreferencesService preferencesService, PerformanceInfoService performanceInfoService, MetadataService metadataService, BreadcrumbService breadcrumbService, PowerService powerService, ActivityService activityService, ApiClient apiClient, EventService eventService, EmbraceRemoteLogger remoteLogger, UserService userService, ConfigService configService, CacheService cacheService, EmbraceExceptionService exceptionService, LocalConfig localConfig, MemoryCleanerService memoryCleanerService, OrientationService orientationService) {
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.performanceInfoService = (PerformanceInfoService)Preconditions.checkNotNull((Object)performanceInfoService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.breadcrumbService = (BreadcrumbService)Preconditions.checkNotNull((Object)breadcrumbService);
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.eventService = (EventService)Preconditions.checkNotNull((Object)eventService);
        this.remoteLogger = (EmbraceRemoteLogger)Preconditions.checkNotNull((Object)remoteLogger);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService);
        this.exceptionService = (EmbraceExceptionService)Preconditions.checkNotNull((Object)exceptionService);
        this.activityService.addListener(this, true);
        this.sessionBackgroundWorker = BackgroundWorker.ofSingleThread("Session");
        this.localConfig = (LocalConfig)Preconditions.checkNotNull((Object)localConfig);
        this.memoryCleanerService = (MemoryCleanerService)Preconditions.checkNotNull((Object)memoryCleanerService);
        this.orientationService = (OrientationService)Preconditions.checkNotNull((Object)orientationService);
    }

    private int incrementAndGetSessionNumber() {
        if (this.preferencesService.getSessionNumber().isPresent()) {
            this.preferencesService.setSessionNumber((Integer)this.preferencesService.getSessionNumber().get() + 1);
        } else {
            this.preferencesService.setSessionNumber(1);
        }
        return (Integer)this.preferencesService.getSessionNumber().get();
    }

    private void startCaching() {
        this.sessionCacheWorker = ScheduledWorker.ofSingleThread("Session Caching Service");
        this.sessionCacheWorker.scheduleAtFixedRate(this::cacheActiveSession, 0L, 2L, TimeUnit.SECONDS);
    }

    private void stopCaching() {
        if (this.sessionCacheWorker != null) {
            this.sessionCacheWorker.close();
        }
    }

    private void startSessionCloser(int maxSessionSeconds) {
        this.automaticSessionCloser = ScheduledWorker.ofSingleThread("Session Closer Service");
        this.automaticSessionCloser.scheduleAtFixedRate(() -> {
            try {
                Object object = this.lock;
                synchronized (object) {
                    EmbraceLogger.logInfo("Automatic session closing triggered.");
                    this.triggerStatelessSessionEnd(Session.SessionLifeEventType.TIMED);
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Error while trying to close the session automatically", ex);
            }
        }, maxSessionSeconds, maxSessionSeconds, TimeUnit.SECONDS);
    }

    private void stopSessionCloser() {
        if (this.automaticSessionCloser != null) {
            this.automaticSessionCloser.close();
        }
    }

    @Override
    public void startSession(boolean coldStart, Session.SessionLifeEventType startType) {
        if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages disabled. Ignoring all sessions.");
            return;
        }
        String sessionId = Uuid.getEmbUuid();
        SessionMessage message = this.sessionStartMessage(coldStart, sessionId, startType);
        this.activeSession = message.getSession();
        this.metadataService.setActiveSessionId(sessionId);
        this.apiClient.sendSession(message);
        LocalConfig.SessionConfig sessionConfig = this.localConfig.getSessionConfig();
        if (sessionConfig.getMaxSessionSeconds().isPresent()) {
            this.startSessionCloser((Integer)sessionConfig.getMaxSessionSeconds().get());
        }
        this.addViewBreadcrumbForResumedSession();
        this.startCaching();
    }

    @Override
    public boolean sdkStartupFailedLastSession() {
        Optional<String> lastSessionStartupProgress = this.preferencesService.getSDKStartupStatus();
        return lastSessionStartupProgress.isPresent() && !((String)lastSessionStartupProgress.get()).equals("startup_completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCrash(String stacktrace) {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeSession != null) {
                SessionMessage sessionMessage = this.sessionEndMessage(this.activeSession, false, false, true, stacktrace, Session.SessionLifeEventType.STATE);
                Unchecked.wrap(() -> this.apiClient.sendSession(sessionMessage).get());
                this.cacheService.deleteObject(SESSION_FILE_NAME);
            }
        }
    }

    private SessionMessage sessionStartMessage(boolean coldStart, String id, Session.SessionLifeEventType startType) {
        Session.Builder builder = Session.newBuilder().withSessionId(id).withStartTime(System.currentTimeMillis()).withNumber(this.incrementAndGetSessionNumber()).withColdStart(coldStart).withStartType(startType).withSessionType(SESSION_START_TYPE);
        if (this.powerService.getLatestBatteryLevel().isPresent()) {
            builder.withStartingBatteryLevel(((Float)this.powerService.getLatestBatteryLevel().get()).floatValue());
        }
        if (!this.orientationService.getOrientations().isEmpty()) {
            builder.withOrientations(this.orientationService.getOrientations());
        }
        if (this.userService.loadUserInfoFromDisk().isPresent()) {
            builder.withUserInfo((UserInfo)this.userService.loadUserInfoFromDisk().get());
        }
        Session session = builder.build();
        return SessionMessage.newBuilder().withSession(session).withDeviceInfo(this.metadataService.getDeviceInfo()).withAppInfo(this.metadataService.getAppInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheActiveSession() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.activeSession != null) {
                    this.cacheSessionMessage(this.sessionEndMessage(this.activeSession, false, true, Session.SessionLifeEventType.STATE));
                }
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Error while caching active session", ex);
        }
    }

    private SessionMessage sessionEndMessage(Session session, boolean endedCleanly, boolean forceQuit, Session.SessionLifeEventType endType) {
        return this.sessionEndMessage(session, endedCleanly, forceQuit, false, null, endType);
    }

    private SessionMessage sessionEndMessage(Session session, boolean endedCleanly, boolean forceQuit, boolean crashed, String stacktrace, Session.SessionLifeEventType endType) {
        Long startTime = session.getStartTime();
        long endTime = System.currentTimeMillis();
        Session.Builder builder = Session.newBuilder(session).withEndedCleanly(endedCleanly).withLastState(this.getApplicationState()).withSessionType(SESSION_END_TYPE).withEventIds(this.eventService.findEventIdsForSession(startTime, endTime)).withInfoLogIds(this.remoteLogger.findInfoLogIds(startTime, endTime)).withWarningLogIds(this.remoteLogger.findWarningLogIds(startTime, endTime)).withErrorLogIds(this.remoteLogger.findErrorLogIds(startTime, endTime)).withExceptionErrors(this.exceptionService.getCurrentExceptionError()).withCrashed(crashed).withLastHeartbeatTime(System.currentTimeMillis()).withEndType(endType);
        if (!this.orientationService.getOrientations().isEmpty()) {
            builder.withOrientations(this.orientationService.getOrientations());
        }
        if (crashed) {
            builder = builder.withExceptionStacktrace(stacktrace);
        }
        builder = forceQuit ? builder.withTerminationTime(System.currentTimeMillis()).withReceivedTermination(true) : builder.withEndTime(endTime);
        Session currentSession = builder.build();
        return SessionMessage.newBuilder().withUserInfo(currentSession.getUser()).withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withPerformanceInfo(this.performanceInfoService.getSessionPerformanceInfo(startTime, endTime)).withBreadcrumbs(this.breadcrumbService.getBreadcrumbs(startTime, endTime)).withSession(currentSession).build();
    }

    private String getApplicationState() {
        return this.activityService.isInBackground() ? APPLICATION_STATE_BACKGROUND : APPLICATION_STATE_ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        Object object = this.lock;
        synchronized (object) {
            if (coldStart) {
                this.sendCachedSession();
            }
            this.startSession(coldStart, Session.SessionLifeEventType.STATE);
        }
    }

    @Override
    public void onBackground() {
        this.endSession(Session.SessionLifeEventType.STATE);
    }

    @Override
    public void triggerStatelessSessionEnd(Session.SessionLifeEventType endType) {
        if (!this.configService.isSessionControlEnabled()) {
            EmbraceLogger.logWarning("Session control disabled from remote configuration.");
            return;
        }
        if (this.activeSession == null) {
            EmbraceLogger.logError("There's no active session to end.");
            return;
        }
        if (System.currentTimeMillis() - this.activeSession.getStartTime() < 5000L) {
            EmbraceLogger.logError("The session has to be of at least 5 seconds to be ended manually.");
            return;
        }
        this.endSession(endType);
        if (!this.activityService.isInBackground()) {
            this.startSession(false, endType);
        }
        EmbraceLogger.logInfo("Session successfully closed.");
    }

    private synchronized void endSession(Session.SessionLifeEventType endType) {
        this.stopCaching();
        this.stopSessionCloser();
        if (this.activeSession != null) {
            if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
                EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
                return;
            }
            SessionMessage sessionMessage = this.sessionEndMessage(this.activeSession, true, false, endType);
            this.cacheSessionMessage(sessionMessage);
            this.activeSession = null;
            this.memoryCleanerService.cleanServicesCollections();
            try {
                this.apiClient.sendSession(sessionMessage).get(2L, TimeUnit.SECONDS);
                this.cacheService.deleteObject(SESSION_FILE_NAME);
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to send session end message", ex);
            }
        }
    }

    private void cacheSessionMessage(SessionMessage sessionMessage) {
        try {
            this.cacheService.cacheObject(SESSION_FILE_NAME, sessionMessage, SessionMessage.class);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to cache session");
        }
    }

    private void addViewBreadcrumbForResumedSession() {
        Optional<String> screen = this.breadcrumbService.getLastViewBreadcrumbScreenName();
        if (screen.isPresent()) {
            this.breadcrumbService.forceLogView((String)screen.orNull(), System.currentTimeMillis());
        } else {
            Optional<Activity> foregroundActivity = this.activityService.getForegroundActivity();
            if (foregroundActivity.isPresent()) {
                this.breadcrumbService.forceLogView(((Activity)foregroundActivity.get()).getLocalClassName(), System.currentTimeMillis());
            }
        }
    }

    private void sendCachedSession() {
        try {
            this.sessionBackgroundWorker.submit(() -> {
                try {
                    Optional<SessionMessage> optionalSession = this.cacheService.loadObject(SESSION_FILE_NAME, SessionMessage.class);
                    if (optionalSession.isPresent()) {
                        this.apiClient.sendSession((SessionMessage)optionalSession.get());
                        this.cacheService.deleteObject(SESSION_FILE_NAME);
                    }
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("Failed to send cached session message on resume", ex);
                }
                return null;
            });
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to create background worker to send cached session during resume", ex);
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Shutting down EmbraceSessionService");
        this.stopCaching();
        this.stopSessionCloser();
        this.sessionBackgroundWorker.close();
    }

    Session getActiveSession() {
        return this.activeSession;
    }
}

