/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Base64;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ExceptionInfo;
import io.embrace.android.embracesdk.JsException;
import io.embrace.android.embracesdk.Uuid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Crash {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="ex")
    private final List<ExceptionInfo> exceptions;
    @SerializedName(value="rep_js")
    private final List<String> jsExceptions;

    private Crash(String id, List<ExceptionInfo> exceptions, List<String> jsExceptions) {
        this.id = id;
        this.exceptions = exceptions;
        this.jsExceptions = jsExceptions;
    }

    static Crash ofThrowable(Throwable throwable, JsException jsException) {
        List<String> jsExceptions = null;
        if (jsException != null) {
            try {
                byte[] jsonException = new Gson().toJson((Object)jsException, jsException.getClass()).getBytes();
                String encodedString = Base64.encodeToString((byte[])jsonException, (int)2);
                jsExceptions = Collections.singletonList(encodedString);
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to parse javascript exception", ex, true);
            }
        }
        return new Crash(Uuid.getEmbUuid(), Crash.exceptionInfo(throwable), jsExceptions);
    }

    private static List<ExceptionInfo> exceptionInfo(Throwable ex) {
        ArrayList<ExceptionInfo> result = new ArrayList<ExceptionInfo>();
        for (Throwable throwable = ex; throwable != null && !throwable.equals(throwable.getCause()); throwable = throwable.getCause()) {
            ExceptionInfo exceptionInfo = ExceptionInfo.ofThrowable(throwable);
            result.add(0, exceptionInfo);
        }
        return result;
    }

    String getCause() {
        return this.exceptions != null && !this.exceptions.isEmpty() ? this.exceptions.get(0).getName() : null;
    }
}

