/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Process;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Interval;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class EmbraceCpuService
implements CpuService {
    private static final double HIGH_CPU_USAGE_THRESHOLD = 0.7;
    private final ScheduledWorker cpuWorker;
    private final NavigableMap<Long, Boolean> cpuPegging;
    private RandomAccessFile procFile;
    private RandomAccessFile pidProcFile;
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private volatile Long lastUptime;
    private volatile Long lastCpuTime;

    EmbraceCpuService() {
        this.cpuWorker = ScheduledWorker.ofSingleThread("CPU Service");
        this.cpuWorker.scheduleAtFixedRate(() -> this.cpuSample(), 0L, 100L, TimeUnit.MILLISECONDS);
        this.cpuPegging = new TreeMap<Long, Boolean>();
        try {
            this.procFile = new RandomAccessFile("/proc/stat", "r");
            this.pidProcFile = new RandomAccessFile("/proc/" + Process.myPid() + "/stat", "r");
        }
        catch (FileNotFoundException ex) {
            EmbraceLogger.logInfo("CPU monitoring is currently not supported on this device.");
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("EmbraceCpuService failed to start. CPU monitoring unavailable.", ex);
        }
        finally {
            this.close();
        }
    }

    private long getTotalUpTime() {
        if (this.procFile != null) {
            try {
                this.procFile.seek(0L);
                String[] stats = this.procFile.readLine().split("[ ]+", 9);
                long userTime = Long.parseLong(stats[1]);
                long niceTime = Long.parseLong(stats[2]);
                long systemTime = Long.parseLong(stats[3]);
                long idleTime = Long.parseLong(stats[4]);
                long ioWaitTime = Long.parseLong(stats[5]);
                long irqTime = Long.parseLong(stats[6]);
                long softIrqTime = Long.parseLong(stats[7]);
                return userTime + niceTime + systemTime + idleTime + ioWaitTime + irqTime + softIrqTime;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalStateException("proc file reader not initialized");
    }

    private long getTotalProcessCpuTime() {
        if (this.pidProcFile != null) {
            try {
                this.pidProcFile.seek(0L);
                String[] stats = this.pidProcFile.readLine().split("[ ]+", 18);
                long userTime = Long.parseLong(stats[13]);
                long systemTime = Long.parseLong(stats[14]);
                long userChildTime = Long.parseLong(stats[15]);
                long systemChildTime = Long.parseLong(stats[16]);
                return userTime + systemTime + userChildTime + systemChildTime;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalStateException("PID proc file reader not initialized");
    }

    private void cpuSample() {
        block4: {
            try {
                long uptime = this.getTotalUpTime();
                long cpuTime = this.getTotalProcessCpuTime();
                if (this.lastUptime != null && this.lastCpuTime != null) {
                    long uptimeDiff = uptime - this.lastUptime;
                    long cpuTimeDiff = cpuTime - this.lastCpuTime;
                    if (uptimeDiff > 0L) {
                        double result = Math.max(1.0, (double)cpuTimeDiff / (double)uptimeDiff);
                        this.saveResult(result);
                    }
                    this.lastUptime = uptime;
                    this.lastCpuTime = cpuTime;
                }
            }
            catch (Exception ex) {
                if (this.failureCount.incrementAndGet() <= 50) break block4;
                EmbraceLogger.logDebug("Failed to sample CPU usage", ex);
                this.failureCount.set(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResult(double result) {
        EmbraceCpuService embraceCpuService = this;
        synchronized (embraceCpuService) {
            boolean pegging;
            boolean bl = pegging = result > 0.7;
            if (this.cpuPegging.isEmpty() || this.cpuPegging.lastEntry().getValue() != pegging) {
                this.cpuPegging.put(System.currentTimeMillis(), pegging);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Interval> getCpuCriticalIntervals(long startTime, long endTime) {
        EmbraceCpuService embraceCpuService = this;
        synchronized (embraceCpuService) {
            ArrayList<Interval> results = new ArrayList<Interval>();
            for (Map.Entry<Long, Boolean> entry : this.cpuPegging.subMap(startTime, endTime).entrySet()) {
                long currentTime;
                if (!entry.getValue().booleanValue()) continue;
                Long next = this.cpuPegging.higherKey(currentTime = entry.getKey().longValue());
                results.add(new Interval(currentTime, next != null ? next : currentTime));
            }
            return results;
        }
    }

    @Override
    public void close() {
        this.cpuWorker.close();
        if (this.procFile != null) {
            Unchecked.wrap(() -> this.procFile.close());
        }
        if (this.pidProcFile != null) {
            Unchecked.wrap(() -> this.pidProcFile.close());
        }
    }
}

