package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * An interval during which the device had a particular class of connection quality.
 */
final class ConnectionQualityInterval {
    /** The start time of the interval. */
    @SerializedName("st")
    private final long startTime;

    /** The end time of the interval. */
    @SerializedName("en")
    private final long endTime;

    /** The quality of the connection. */
    @SerializedName("cq")
    private final ConnectionQuality connectionQuality;

    /** The estimated bandwidth available to the device during this period. */
    @SerializedName("bw")
    private final Integer bandwidth;

    ConnectionQualityInterval(long startTime, long endTime, ConnectionQuality connectionQuality, Integer bandwidth) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.connectionQuality = connectionQuality;
        this.bandwidth = bandwidth;
    }
}
