package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;

/**
 * Handles the caching of objects.
 */
interface CacheService {

    /**
     * Caches the specified object.
     *
     * @param name the name of the object to cache
     * @param object the object to cache
     * @param clazz the class of the object to cache
     * @param <T> the type of the object
     */
    <T> void cacheObject(String name, T object, Class<T> clazz);

    /**
     * Reads the specified object from the cache, if it exists.
     *
     * @param name the name of the object to read from the cache
     * @param clazz the class of the cached object
     * @param <T> the type of the cached object
     * @return optionally the object, if it can be read successfully
     */
    <T> Optional<T> loadObject(String name, Class<T> clazz);

    /**
     * Deletes the specified object from the cache.
     *
     * @param name the name of the object to delete
     * @return true if the file was successfully deleted, false otherwise
     */
    boolean deleteObject(String name);

}
