/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import com.fernandocejas.arrow.optional.Optional;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.IOException;
import java.io.InputStream;

final class LocalConfig {
    private static final String FILE_LOCAL_CONFIG = "embrace-config.json";
    @SerializedName(value="base_urls")
    private final BaseUrls baseUrls;
    @SerializedName(value="crash_handler")
    private final CrashHandler crashHandler;
    @SerializedName(value="startup_moment")
    private final StartupMoment startupMoment;
    @SerializedName(value="networking")
    private final Networking networking;

    LocalConfig() {
        this(null, null, null, null);
    }

    private LocalConfig(BaseUrls baseUrls, CrashHandler crashHandler, StartupMoment startupMoment, Networking networking) {
        this.baseUrls = (BaseUrls)Optional.fromNullable((Object)baseUrls).or((Object)new BaseUrls());
        this.crashHandler = (CrashHandler)Optional.fromNullable((Object)crashHandler).or((Object)new CrashHandler());
        this.startupMoment = (StartupMoment)Optional.fromNullable((Object)startupMoment).or((Object)new StartupMoment());
        this.networking = (Networking)Optional.fromNullable((Object)networking).or((Object)new Networking());
    }

    BaseUrls getBaseUrls() {
        return this.baseUrls;
    }

    CrashHandler getCrashHandler() {
        return this.crashHandler;
    }

    StartupMoment getStartupMoment() {
        return this.startupMoment;
    }

    Networking getNetworking() {
        return this.networking;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LocalConfig fromFile(Context context) {
        try (InputStream inputStream = context.getApplicationContext().getAssets().open(FILE_LOCAL_CONFIG);){
            LocalConfig localConfig = LocalConfig.fromInputStream(inputStream);
            return localConfig;
        }
        catch (IOException e) {
            EmbraceLogger.logDebug("Embrace config file embrace-config.json does not exist");
            return new LocalConfig();
        }
    }

    /*
     * Exception decompiling
     */
    static LocalConfig fromInputStream(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class Networking {
        static final String CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE = "x-emb-trace-id";
        @SerializedName(value="trace_id_header")
        private String traceIdHeader;

        Networking() {
            this(null);
        }

        Networking(String traceIdHeader) {
            this.traceIdHeader = (String)Optional.fromNullable((Object)traceIdHeader).or((Object)CONFIG_TRACE_ID_HEADER_DEFAULT_VALUE);
        }

        String getTraceIdHeader() {
            return this.traceIdHeader;
        }
    }

    static class StartupMoment {
        static final Boolean AUTOMATICALLY_END_DEFAULT = true;
        @SerializedName(value="automatically_end")
        private Boolean automaticallyEnd;

        StartupMoment() {
            this(null);
        }

        StartupMoment(Boolean automaticallyEnd) {
            this.automaticallyEnd = (Boolean)Optional.fromNullable((Object)automaticallyEnd).or((Object)AUTOMATICALLY_END_DEFAULT);
        }

        Boolean getAutomaticallyEnd() {
            return this.automaticallyEnd;
        }
    }

    static class CrashHandler {
        static final Boolean ENABLED_DEFAULT = true;
        @SerializedName(value="enabled")
        private Boolean enabled;

        CrashHandler() {
            this(null);
        }

        CrashHandler(Boolean enabled) {
            this.enabled = (Boolean)Optional.fromNullable((Object)enabled).or((Object)ENABLED_DEFAULT);
        }

        Boolean getEnabled() {
            return this.enabled;
        }
    }

    static class BaseUrls {
        static final String CONFIG_DEFAULT = "https://config.emb-api.com";
        static final String DATA_DEFAULT = "https://data.emb-api.com";
        static final String DATA_DEV_DEFAULT = "https://data-dev.emb-api.com";
        static final String IMAGES_DEFAULT = "https://images.emb-api.com";
        @SerializedName(value="data")
        private String data;
        @SerializedName(value="data_dev")
        private String dataDev;
        @SerializedName(value="config")
        private String config;
        @SerializedName(value="images")
        private String images;

        BaseUrls() {
            this(null, null, null, null);
        }

        BaseUrls(String config, String data, String dataDev, String images) {
            this.config = (String)Optional.fromNullable((Object)config).or((Object)CONFIG_DEFAULT);
            this.data = (String)Optional.fromNullable((Object)data).or((Object)DATA_DEFAULT);
            this.dataDev = (String)Optional.fromNullable((Object)dataDev).or((Object)DATA_DEV_DEFAULT);
            this.images = (String)Optional.fromNullable((Object)images).or((Object)IMAGES_DEFAULT);
        }

        String getConfig() {
            return this.config;
        }

        String getData() {
            return this.data;
        }

        String getDataDev() {
            return this.dataDev;
        }

        String getImages() {
            return this.images;
        }
    }
}

