/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.http;

import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.HttpPathOverrideRequest;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class EmbraceHttpUrlConnectionOverride
implements HttpPathOverrideRequest {
    private final HttpURLConnection connection;

    EmbraceHttpUrlConnectionOverride(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public String getHeaderByName(String name) {
        return this.connection.getRequestProperty(name);
    }

    @Override
    public String getOverriddenURL(String pathOverride) {
        try {
            return new URL(this.connection.getURL().getProtocol(), this.connection.getURL().getHost(), this.connection.getURL().getPort(), pathOverride).toString();
        }
        catch (MalformedURLException e) {
            EmbraceLogger.logError(String.format(Locale.US, "Failed to override path of %s with %s", this.connection.getURL(), pathOverride));
            return this.connection.getURL().toString();
        }
    }

    @Override
    public String getURLString() {
        return this.connection.getURL().toString();
    }
}

