/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ApiRequest;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ScheduledWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class ApiClientRetryWorker<T> {
    private static final int RETRY_WORKER_PERIOD = 10;
    private final Class<T> clazz;
    private final CacheService cacheService;
    private final Queue<FailedApiCall<T>> failedApiCalls = new ConcurrentLinkedQueue<FailedApiCall<T>>();
    private final String cacheKey;
    private final ApiClient apiClient;
    private final ScheduledWorker worker;

    ApiClientRetryWorker(Class<T> clazz, CacheService cacheService, ApiClient apiClient, ScheduledWorker worker) {
        this.clazz = clazz;
        this.cacheService = cacheService;
        this.apiClient = apiClient;
        this.cacheKey = "network_failed_" + clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.worker = worker;
        this.start();
    }

    synchronized void addFailedCall(ApiRequest request, T payload) {
        this.failedApiCalls.add(new FailedApiCall<T>(request, payload));
        List retries = (List)StreamSupport.stream(this.failedApiCalls).collect(Collectors.toList());
        this.cacheService.cacheObject(this.cacheKey, new FailedCalls(retries), FailedCalls.class);
    }

    private void start() {
        Optional<FailedCalls> optionalCalls = this.cacheService.loadObject(this.cacheKey, FailedCalls.class);
        if (optionalCalls.isPresent()) {
            this.failedApiCalls.addAll(((FailedCalls)optionalCalls.get()).failedApiCalls);
        }
        this.worker.scheduleAtFixedRate(() -> {
            ApiClientRetryWorker apiClientRetryWorker = this;
            synchronized (apiClientRetryWorker) {
                try {
                    ArrayList reattempts = new ArrayList();
                    FailedApiCall<T> lastCall = this.failedApiCalls.poll();
                    while (lastCall != null) {
                        reattempts.add(lastCall);
                        lastCall = this.failedApiCalls.poll();
                    }
                    this.cacheService.cacheObject(this.cacheKey, new FailedCalls(reattempts), FailedCalls.class);
                    for (FailedApiCall failedApiCall : reattempts) {
                        this.apiClient.jsonPost(failedApiCall.apiRequest, failedApiCall.payload, this.clazz, this::addFailedCall);
                    }
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("Error in ApiClient retry worker", ex);
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private static class FailedCalls<P> {
        private final List<FailedApiCall<P>> failedApiCalls;

        FailedCalls(List<FailedApiCall<P>> failedApiCalls) {
            this.failedApiCalls = failedApiCalls;
        }
    }

    private static class FailedApiCall<P> {
        private final ApiRequest apiRequest;
        private final P payload;

        FailedApiCall(ApiRequest apiRequest, P payload) {
            this.apiRequest = apiRequest;
            this.payload = payload;
        }
    }
}

