package io.embrace.android.embracesdk;

import java.nio.charset.Charset;

final class EmbraceNetworkUtils {

    private static final int TRACE_ID_MAXIMUM_ALLOWED_LENGTH = 64;

    static String getValidTraceId(String traceId) {

        if (traceId == null) {
            EmbraceLogger.logError("Ignoring null traceId");
            return null;
        }

        if (!Charset.forName("US-ASCII").newEncoder().canEncode(traceId)) {
            EmbraceLogger.logError(String.format("Relative path must not contain unicode characters. Relative path %s will be ignored.", traceId));
            return null;
        }

        if (traceId.length() > TRACE_ID_MAXIMUM_ALLOWED_LENGTH) {
            EmbraceLogger.logError(String.format("Truncating traceId to %s characters", traceId));
            traceId = traceId.substring(0, TRACE_ID_MAXIMUM_ALLOWED_LENGTH);
        }

        return traceId;
    }
}
