package io.embrace.android.embracesdk;

/**
 * Service for handling crashes intercepted by the {@link EmbraceUncaughtExceptionHandler} and
 * forwarding them on for processing.
 */
interface CrashService {
    /**
     * Handles crashes from the {@link EmbraceUncaughtExceptionHandler}.
     *
     * @param thread the crashing thread
     * @param exception the exception thrown by the thread
     */
    void handleCrash(Thread thread, Throwable exception);

}
