/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Application;
import android.content.Context;
import android.util.Pair;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.CrashService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceAnrService;
import io.embrace.android.embracesdk.EmbraceBreadcrumbService;
import io.embrace.android.embracesdk.EmbraceCacheService;
import io.embrace.android.embracesdk.EmbraceConfigService;
import io.embrace.android.embracesdk.EmbraceConnectionClassService;
import io.embrace.android.embracesdk.EmbraceCpuService;
import io.embrace.android.embracesdk.EmbraceCrashService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceEventService;
import io.embrace.android.embracesdk.EmbraceExceptionService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceMemoryCleanerService;
import io.embrace.android.embracesdk.EmbraceMemoryService;
import io.embrace.android.embracesdk.EmbraceMetadataService;
import io.embrace.android.embracesdk.EmbraceNetworkConnectivityService;
import io.embrace.android.embracesdk.EmbraceNetworkLoggingService;
import io.embrace.android.embracesdk.EmbracePerformanceInfoService;
import io.embrace.android.embracesdk.EmbracePowerService;
import io.embrace.android.embracesdk.EmbracePreferencesService;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EmbraceScreenshotService;
import io.embrace.android.embracesdk.EmbraceSessionService;
import io.embrace.android.embracesdk.EmbraceSignalQualityService;
import io.embrace.android.embracesdk.EmbraceUserService;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.LocalConfig;
import io.embrace.android.embracesdk.MemoryCleanerService;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.NetworkConnectivityService;
import io.embrace.android.embracesdk.NetworkLoggingService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.PropertyUtils;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SignalQualityService;
import io.embrace.android.embracesdk.StreamHandlerFactoryInstaller;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.network.http.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Embrace {
    private static final Embrace embrace = new Embrace();
    private volatile Application application;
    private volatile CacheService cacheService;
    private volatile CrashService crashService;
    private volatile BreadcrumbService breadcrumbService;
    private volatile EmbraceSessionService sessionService;
    private volatile MetadataService metadataService;
    private volatile PerformanceInfoService performanceInfoService;
    private volatile PowerService powerService;
    private volatile MemoryService memoryService;
    private volatile EmbraceActivityService activityService;
    private volatile NetworkConnectivityService networkConnectivityService;
    private volatile NetworkLoggingService networkLoggingService;
    private volatile CpuService cpuService;
    private volatile BuildInfo buildInfo;
    private volatile LocalConfig localConfig;
    private volatile AnrService anrService;
    private volatile EmbraceRemoteLogger remoteLogger;
    private volatile ConfigService configService;
    private volatile PreferencesService preferencesService;
    private volatile ScreenshotService screenshotService;
    private volatile EventService eventService;
    private volatile UserService userService;
    private volatile SignalQualityService signalQualityService;
    private volatile EmbraceExceptionService exceptionsService;
    private volatile MemoryCleanerService memoryCleanerService;
    private volatile AtomicBoolean started = new AtomicBoolean(false);
    private static final String ERROR_NOT_INITIALIZED = "Embrace SDK is not initialized yet, cannot log event";
    private static final String ERROR_USER_UPDATES_DISABLED = "User updates are disabled, ignoring user persona update.";

    public static Embrace getInstance() {
        return embrace;
    }

    public void start(Application application) {
        this.start(application, true);
    }

    public void start(Application application, boolean enableIntegrationTesting) {
        Preconditions.checkState((this.application == null ? 1 : 0) != 0, (Object)"Embrace SDK has already been initialized");
        this.application = (Application)Preconditions.checkNotNull((Object)application, (Object)"application must not be null");
        Context context = this.application.getApplicationContext();
        try {
            this.memoryCleanerService = new EmbraceMemoryCleanerService();
            this.powerService = new EmbracePowerService(context, this.memoryCleanerService);
            this.memoryService = EmbraceMemoryService.ofContext(context, this.memoryCleanerService);
            this.activityService = new EmbraceActivityService(application, this.memoryService);
            this.exceptionsService = new EmbraceExceptionService(this.activityService);
            this.preferencesService = new EmbracePreferencesService(context, this.activityService);
            this.networkConnectivityService = new EmbraceNetworkConnectivityService(context, this.memoryCleanerService);
            this.cpuService = new EmbraceCpuService();
            this.anrService = new EmbraceAnrService(this.memoryCleanerService);
            this.buildInfo = BuildInfo.fromFile(context);
            this.localConfig = LocalConfig.fromFile(context);
            this.metadataService = EmbraceMetadataService.ofContext(context, this.buildInfo, this.preferencesService, this.activityService);
            EmbraceConnectionClassService connectionClassService = new EmbraceConnectionClassService(this.memoryCleanerService);
            this.cacheService = new EmbraceCacheService(context);
            ApiClient apiClient = new ApiClient(this.localConfig, this.metadataService, this.cacheService, enableIntegrationTesting);
            this.configService = new EmbraceConfigService(apiClient, this.activityService, this.cacheService, this.metadataService);
            this.exceptionsService.setConfigService(this.configService);
            this.signalQualityService = new EmbraceSignalQualityService(context, this.configService, this.activityService, connectionClassService, this.memoryCleanerService);
            this.breadcrumbService = new EmbraceBreadcrumbService(this.configService, this.activityService, this.memoryCleanerService);
            if (this.configService.isSdkDisabled()) {
                this.stop();
                return;
            }
            this.userService = new EmbraceUserService(this.activityService, this.preferencesService, apiClient);
            this.screenshotService = new EmbraceScreenshotService(this.activityService, this.configService, apiClient);
            this.networkLoggingService = new EmbraceNetworkLoggingService(connectionClassService, this.configService, this.buildInfo, this.memoryCleanerService);
            this.performanceInfoService = new EmbracePerformanceInfoService(this.anrService, this.networkConnectivityService, this.networkLoggingService, this.powerService, this.cpuService, this.memoryService, this.signalQualityService, connectionClassService, this.metadataService);
            this.eventService = new EmbraceEventService(apiClient, this.configService, this.localConfig, this.metadataService, this.performanceInfoService, this.userService, this.screenshotService, this.activityService, this.memoryCleanerService);
            this.remoteLogger = new EmbraceRemoteLogger(this.metadataService, this.screenshotService, apiClient, this.userService, this.configService, this.memoryCleanerService);
            this.sessionService = new EmbraceSessionService(this.preferencesService, this.performanceInfoService, this.metadataService, this.breadcrumbService, this.powerService, this.activityService, apiClient, this.eventService, this.remoteLogger, this.userService, this.configService, this.cacheService, this.exceptionsService, this.buildInfo, this.memoryCleanerService);
            this.crashService = new EmbraceCrashService(this.localConfig, this.sessionService, this.metadataService, apiClient, this.userService, this.eventService);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Exception occurred while initializing the Embrace SDK. Instrumentation may be disabled.", ex, true);
            return;
        }
        EmbraceLogger.logInfo(String.format("Embrace SDK started. Version: %s", "3.2.4"));
        StreamHandlerFactoryInstaller.registerFactory();
        this.started.set(true);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    void stop() {
        if (this.started.compareAndSet(true, false)) {
            EmbraceLogger.logInfo("Shutting down Embrace SDK.");
            try {
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.powerService != null) {
                    this.powerService.close();
                }
                if (this.memoryService != null) {
                    this.memoryService.close();
                }
                if (this.cpuService != null) {
                    this.cpuService.close();
                }
                if (this.anrService != null) {
                    this.anrService.close();
                }
                if (this.activityService != null) {
                    this.activityService.close();
                }
                if (this.sessionService != null) {
                    this.sessionService.close();
                }
                if (this.eventService != null) {
                    this.eventService.close();
                }
                if (this.networkConnectivityService != null) {
                    this.networkConnectivityService.close();
                }
                if (this.signalQualityService != null) {
                    this.signalQualityService.close();
                }
                this.memoryCleanerService = null;
                this.powerService = null;
                this.memoryService = null;
                this.breadcrumbService = null;
                this.activityService = null;
                this.preferencesService = null;
                this.networkConnectivityService = null;
                this.cpuService = null;
                this.anrService = null;
                this.buildInfo = null;
                this.localConfig = null;
                this.metadataService = null;
                this.performanceInfoService = null;
                this.cacheService = null;
                this.userService = null;
                this.screenshotService = null;
                this.eventService = null;
                this.remoteLogger = null;
                this.sessionService = null;
                this.crashService = null;
                this.signalQualityService = null;
                this.networkLoggingService = null;
                this.application = null;
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Error while shutting down Embrace SDK", ex);
            }
        }
    }

    @Deprecated
    public void setLogLevel(EmbraceLogger.Severity severity) {
    }

    public void setUserIdentifier(String userId) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.setUserIdentifier(userId);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user identifier");
        }
    }

    public void clearUserIdentifier() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring identifier update.");
                return;
            }
            this.userService.clearUserIdentifier();
        }
    }

    public void setUserEmail(String email) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.setUserEmail(email);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user identifier");
        }
    }

    public void clearUserEmail() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring email update.");
                return;
            }
            this.userService.clearUserEmail();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user email");
        }
    }

    public void setUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.setUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user as payer");
        }
    }

    public void clearUserAsPayer() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring payer user update.");
                return;
            }
            this.userService.clearUserAsPayer();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user as payer");
        }
    }

    public void setUserPersona(String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.setUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set user persona");
        }
    }

    public void clearUserPersona(String persona) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearUserPersona(persona);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user persona");
        }
    }

    public void clearAllUserPersonas() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning(ERROR_USER_UPDATES_DISABLED);
                return;
            }
            this.userService.clearAllUserPersonas();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear user personas");
        }
    }

    public void setUsername(String username) {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.setUsername(username);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot set username");
        }
    }

    public void clearUsername() {
        if (this.isStarted()) {
            if (this.configService.isMessageTypeDisabled(MessageType.USER)) {
                EmbraceLogger.logWarning("User updates are disabled, ignoring username update.");
                return;
            }
            this.userService.clearUsername();
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot clear username");
        }
    }

    public void startEvent(String name) {
        if (this.isStarted()) {
            this.eventService.startEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(String name, String identifier) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier);
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot) {
        if (this.isStarted()) {
            this.eventService.startEvent(name, identifier, allowScreenshot);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void startEvent(String name, String identifier, boolean allowScreenshot, Map<String, Object> properties) {
        if (this.isStarted()) {
            HashMap<String, Object> normalizedProperties = new HashMap();
            if (properties != null) {
                normalizedProperties = PropertyUtils.sanitizeProperties(properties);
            }
            this.eventService.startEvent(name, identifier, allowScreenshot, normalizedProperties);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name) {
        if (this.isStarted()) {
            this.eventService.endEvent(name);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name, String identifier) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endEvent(String name, String identifier, Map<String, Object> properties) {
        if (this.isStarted()) {
            this.eventService.endEvent(name, identifier, properties);
        } else {
            EmbraceLogger.logWarning(ERROR_NOT_INITIALIZED);
        }
    }

    public void endAppStartup() {
        this.endEvent("_startup");
    }

    public void endAppStartup(Map<String, Object> properties) {
        this.endEvent("_startup", null, properties);
    }

    public void logNetworkCall(String url, HttpMethod httpMethod, int statusCode, long startTime, long endTime, long bytesSent, long bytesReceived) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkCall(url, httpMethod.name(), statusCode, startTime, endTime, bytesSent, bytesReceived);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log network call");
        }
    }

    public void logNetworkClientError(String url, HttpMethod httpMethod, long startTime, long endTime, String errorType, String errorMessage) {
        if (this.isStarted()) {
            if (this.configService.isUrlDisabled(url)) {
                EmbraceLogger.logWarning("Recording of network calls disabled for url: " + url);
                return;
            }
            this.networkLoggingService.logNetworkError(url, httpMethod.name(), startTime, endTime, errorType, errorMessage);
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot log network error");
        }
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.INFO_LOG, message, properties, false);
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.WARNING_LOG, message, properties, false);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Map<String, Object> properties) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, true);
    }

    public void logError(String message, Map<String, Object> properties, boolean allowScreenshot) {
        this.logMessage(EmbraceEvent.Type.ERROR_LOG, message, properties, allowScreenshot);
    }

    void logMessage(EmbraceEvent.Type type, String message, Map<String, Object> properties, boolean allowScreenshot) {
        if (this.isStarted()) {
            try {
                this.remoteLogger.log(message, type, allowScreenshot, properties);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to log message using Embrace SDK.", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log message.");
        }
    }

    public void logBreadcrumb(String message) {
        if (this.isStarted()) {
            this.breadcrumbService.logCustom(message, System.currentTimeMillis());
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot log breadcrumb.");
        }
    }

    public void addConnectionQualityListener(ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.addListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to add connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logDebug("Embrace SDK is not initialized yet, cannot add listener.");
        }
    }

    public void removeConnectionQualityListener(ConnectionQualityListener listener) {
        if (this.isStarted()) {
            try {
                this.signalQualityService.removeListener(listener);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to remove connection quality listener", ex);
            }
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot remove listener.");
        }
    }

    public synchronized void endSession() {
        if (this.isStarted()) {
            if (this.buildInfo.getSessionConfig().isPresent() && ((BuildInfo.SessionConfig)this.buildInfo.getSessionConfig().get()).getMaxSessionSeconds().isPresent()) {
                EmbraceLogger.logWarning("Can't close the session, automatic session close enabled.");
                return;
            }
            this.sessionService.triggerStatelessSessionEnd(Session.SessionLifeEventType.MANUAL);
        } else {
            EmbraceLogger.logWarning("Embrace SDK is not initialized yet, cannot end session.");
        }
    }

    void logView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.logView(screen, System.currentTimeMillis());
        }
    }

    void logWebView(String url) {
        if (this.isStarted()) {
            this.breadcrumbService.logWebView(url, System.currentTimeMillis());
        }
    }

    void forceLogView(String screen) {
        if (this.isStarted()) {
            this.breadcrumbService.forceLogView(screen, System.currentTimeMillis());
        }
    }

    void logTap(Pair<Float, Float> point, String elementName, TapBreadcrumb.TapBreadcrumbType type) {
        if (this.isStarted()) {
            this.breadcrumbService.logTap(point, elementName, System.currentTimeMillis(), type);
        }
    }

    EventService getEventService() {
        return this.eventService;
    }

    EmbraceRemoteLogger getRemoteLogger() {
        return this.remoteLogger;
    }

    EmbraceExceptionService getExceptionsService() {
        return this.exceptionsService;
    }

    MetadataService getMetadataService() {
        return this.metadataService;
    }
}

