package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;

import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ScheduledWorker implements Closeable {
    private final ScheduledExecutorService executorService;

    ScheduledWorker(ScheduledExecutorService executorService) {
        this.executorService = Preconditions.checkNotNull(executorService, "executorService must not be null");
    }

    ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit timeUnit) {
        return this.executorService.scheduleAtFixedRate(task, initialDelay, period, timeUnit);
    }

    ScheduledFuture<?> scheduleWithDelay(Runnable task, long delay, TimeUnit timeUnit) {
        return this.executorService.schedule(task, delay, timeUnit);
    }

    static ScheduledWorker ofSingleThread(String name) {
        return new ScheduledWorker(createScheduledExecutor(name));
    }

    private static ScheduledExecutorService createScheduledExecutor(String name) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(WorkerUtils.createTheadFactory(name));
        WorkerUtils.shutdownHook(executor, name);
        return executor;
    }

    @Override
    public void close() {
        executorService.shutdown();
    }

    public boolean isShutdown() {
        return executorService.isShutdown();
    }
}
