/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import com.fernandocejas.arrow.strings.Charsets;
import com.google.gson.Gson;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class EmbraceCacheService
implements CacheService {
    private static final String EMBRACE_PREFIX = "emb_";
    private final Gson gson = new Gson();
    private final Context context;

    EmbraceCacheService(Context context) {
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void cacheObject(String name, T object, Class<T> clazz) {
        BufferedWriter bw = null;
        FileWriter fw = null;
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        try {
            fw = new FileWriter(file.getAbsoluteFile());
            bw = new BufferedWriter(fw);
            bw.write(this.gson.toJson(object, clazz));
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to store cache object " + file.getPath(), ex);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to close cache writer " + file.getPath(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<T> loadObject(String name, Class<T> clazz) {
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        InputStreamReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)inputStream, Charsets.UTF_8);
            Object obj = this.gson.fromJson((Reader)reader, clazz);
            if (obj != null) {
                Optional optional = Optional.of((Object)obj);
                return optional;
            }
        }
        catch (FileNotFoundException ex) {
            EmbraceLogger.logDebug("Cache file cannot be found " + file.getPath());
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to read cache object " + file.getPath(), ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("Failed to close input stream " + file.getPath(), ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    EmbraceLogger.logDebug("Failed to close cache reader " + file.getPath(), ex);
                }
            }
        }
        return Optional.absent();
    }

    @Override
    public boolean deleteObject(String name) {
        File file = new File(this.context.getCacheDir(), EMBRACE_PREFIX + name);
        try {
            return file.delete();
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to delete cache object " + file.getPath());
            return false;
        }
    }
}

