/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.ConnectionClassService;
import io.embrace.android.embracesdk.ConnectionQuality;
import io.embrace.android.embracesdk.ConnectionQualityListener;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.SignalQualityService;
import io.embrace.android.embracesdk.SignalStrength;
import io.embrace.android.embracesdk.SignalStrengthUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java9.util.stream.StreamSupport;

final class EmbraceSignalQualityService
extends PhoneStateListener
implements SignalQualityService,
ConnectionQualityListener {
    private static final long MIN_TIME_BETWEEN_SAMPLES = 10000L;
    private final NavigableMap<Long, SignalStrength> signalStrength;
    private final TelephonyManager telephonyManager;
    private final ConfigService configService;
    private final SignalStrengthUtils signalStrengthUtils;
    private final Set<ConnectionQualityListener> listeners = new CopyOnWriteArraySet<ConnectionQualityListener>();
    private volatile int signalLevel = 0;
    private volatile ConnectionQuality lastQuality = ConnectionQuality.UNKNOWN;
    private volatile boolean estimatedQuality = true;
    private volatile int lastBandwidth = 0;
    private volatile boolean signalStrengthListening = false;

    EmbraceSignalQualityService(Context context, ConfigService configService, ActivityService activityService, ConnectionClassService connectionClassService) {
        this.signalStrength = new ConcurrentSkipListMap<Long, SignalStrength>();
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        Preconditions.checkNotNull((Object)connectionClassService, (Object)"connectionClassService must not be null");
        this.signalStrengthUtils = new SignalStrengthUtils(context);
        configService.addListener(this);
        activityService.addListener(this);
        connectionClassService.addListener(this);
    }

    @Override
    public List<SignalStrength> getSignalMeasurements(long startTime, long endTime) {
        return new ArrayList<SignalStrength>(this.signalStrength.subMap(startTime, endTime).values());
    }

    @Override
    public ConnectionQuality getEstimatedConnectionQuality() {
        switch (this.signalLevel) {
            case 0: {
                return ConnectionQuality.UNKNOWN;
            }
            case 1: {
                return ConnectionQuality.POOR;
            }
            case 2: {
                return ConnectionQuality.MODERATE;
            }
            case 3: {
                return ConnectionQuality.GOOD;
            }
            case 4: {
                return ConnectionQuality.EXCELLENT;
            }
        }
        return ConnectionQuality.UNKNOWN;
    }

    public void onSignalStrengthsChanged(android.telephony.SignalStrength signalStrength) {
        ConnectionQuality newEstimate;
        long now = System.currentTimeMillis();
        if (this.signalStrength.isEmpty() || now - (Long)this.signalStrength.lastKey() >= 10000L) {
            SignalStrength result = SignalStrength.of(signalStrength);
            this.signalStrength.put(now, result);
        }
        this.signalLevel = this.signalStrengthUtils.getLevel(signalStrength);
        if (this.estimatedQuality && this.signalLevel != 0 && !(newEstimate = this.getEstimatedConnectionQuality()).equals((Object)this.lastQuality)) {
            this.notifyListeners(this.lastQuality, newEstimate, 0);
            this.lastQuality = newEstimate;
        }
    }

    @Override
    public void onConfigChange(Config previousConfig, Config newConfig) {
        if (!previousConfig.getSignalStrengthEnabled().equals(newConfig.getSignalStrengthEnabled())) {
            if (newConfig.getSignalStrengthEnabled().booleanValue()) {
                this.registerPhoneStateListener();
                EmbraceLogger.logDebug("Starting signal strength listener as config was changed");
            } else {
                this.deregisterPhoneStateListener();
                EmbraceLogger.logDebug("Stopping signal strength listener as config was changed");
            }
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logDebug("Stopping EmbraceSignalQualityService");
        this.deregisterPhoneStateListener();
    }

    @Override
    public void onBackground() {
        EmbraceLogger.logDebug("Pausing signal strength collection as app going to background");
        this.deregisterPhoneStateListener();
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        EmbraceLogger.logDebug("Resuming signal strength collection as app in foreground");
        this.registerPhoneStateListener();
    }

    @Override
    public void addListener(ConnectionQualityListener listener) {
        this.listeners.add(listener);
        try {
            listener.onConnectionQualityChange(this.lastQuality, this.lastQuality, this.lastBandwidth);
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to notify ConnectionQualityListener", ex);
        }
    }

    @Override
    public void removeListener(ConnectionQualityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onConnectionQualityChange(ConnectionQuality previousConnectionQuality, ConnectionQuality newConnectionQuality, int currentBandwidth) {
        if (newConnectionQuality.equals((Object)ConnectionQuality.UNKNOWN)) {
            ConnectionQuality estimated = this.getEstimatedConnectionQuality();
            if (estimated != ConnectionQuality.UNKNOWN) {
                this.notifyListeners(previousConnectionQuality, estimated, currentBandwidth);
                this.lastQuality = estimated;
                this.estimatedQuality = true;
            }
        } else {
            this.estimatedQuality = false;
            this.notifyListeners(previousConnectionQuality, newConnectionQuality, currentBandwidth);
            this.lastQuality = newConnectionQuality;
        }
        this.lastBandwidth = currentBandwidth;
    }

    private void registerPhoneStateListener() {
        if (this.telephonyManager != null && this.configService.getConfig().getSignalStrengthEnabled().booleanValue() && !this.signalStrengthListening) {
            try {
                this.telephonyManager.listen((PhoneStateListener)this, 256);
                this.signalStrengthListening = true;
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to register signal strength listener", ex);
            }
        }
    }

    private void deregisterPhoneStateListener() {
        if (this.telephonyManager != null && this.signalStrengthListening) {
            try {
                this.telephonyManager.listen((PhoneStateListener)this, 0);
                this.signalStrengthListening = false;
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to deregister signal strength listener", ex);
            }
        }
    }

    private void notifyListeners(ConnectionQuality previousQuality, ConnectionQuality newQuality, int bandwidth) {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onConnectionQualityChange(previousQuality, newQuality, bandwidth);
            }
            catch (Exception ex) {
                EmbraceLogger.logDebug("Failed to notify ConnectionQualityListener", ex);
            }
        });
    }
}

