/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.util.Log;
import com.fernandocejas.arrow.checks.Preconditions;
import java.util.Map;

public class EmbraceLogger {
    private static Severity threshold = Severity.INFO;

    private EmbraceLogger() {
    }

    public static void setThreshold(Severity threshold) {
        EmbraceLogger.threshold = (Severity)((Object)Preconditions.checkNotNull((Object)((Object)threshold), (Object)"threshold must not be null"));
    }

    public static void logDebug(String msg) {
        EmbraceLogger.log(Severity.DEBUG, msg, null, null);
    }

    public static void logDebug(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.DEBUG, msg, throwable, null);
    }

    public static void logDebug(String msg, Throwable throwable, Map<String, Object> data) {
        EmbraceLogger.log(Severity.DEBUG, msg, throwable, data);
    }

    public static void logInfo(String msg) {
        EmbraceLogger.log(Severity.INFO, msg, null, null);
    }

    public static void logInfo(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.INFO, msg, throwable, null);
    }

    public static void logInfo(String msg, Throwable throwable, Map<String, Object> data) {
        EmbraceLogger.log(Severity.INFO, msg, throwable, data);
    }

    public static void logWarning(String msg) {
        EmbraceLogger.log(Severity.WARNING, msg, null, null);
    }

    public static void logWarning(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.WARNING, msg, throwable, null);
    }

    public static void logWarning(String msg, Throwable throwable, Map<String, Object> data) {
        EmbraceLogger.log(Severity.WARNING, msg, throwable, data);
    }

    public static void logError(String msg) {
        EmbraceLogger.log(Severity.ERROR, msg, null, null);
    }

    public static void logError(String msg, Throwable throwable) {
        EmbraceLogger.log(Severity.ERROR, msg, throwable, null);
    }

    public static void logError(String msg, Throwable throwable, Map<String, Object> data) {
        EmbraceLogger.log(Severity.ERROR, msg, throwable, data);
    }

    public static void log(Severity severity, String msg, Throwable throwable, Map<String, Object> data) {
        if (severity == null) {
            throw new IllegalArgumentException("Severity is null or blank.");
        }
        if (msg == null) {
            msg = "";
        }
        if (severity.ordinal() >= threshold.ordinal()) {
            Log.e((String)"[Embrace]", (String)String.format("%s %s", msg, Log.getStackTraceString((Throwable)throwable)));
        }
    }

    public static enum Severity {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        NONE;

    }
}

