package io.embrace.android.embracesdk;

import android.util.Pair;

import io.embrace.android.embracesdk.TapBreadcrumb.TapBreadcrumbType;

public final class ViewSwazzledHooks {

    private final static String UNKNOWN_ELEMENT_NAME = "Unknown element";

    private static void logOnClickEvent(android.view.View view, TapBreadcrumbType breadcrumbType) {
        String viewName = "";
        try {
            viewName = view.getResources().getResourceName(view.getId());
        } catch (Exception e) {
            viewName = UNKNOWN_ELEMENT_NAME;
        } finally {
            Embrace.getInstance().logTap(new Pair<>(view.getX(), view.getY()), viewName, breadcrumbType);
        }
    }

    public static final class OnClickListener {
        public static void _preOnClick(android.view.View.OnClickListener thiz, android.view.View view) {
            logOnClickEvent(view, TapBreadcrumbType.TAP);
        }
    }

    public static final class OnLongClickListener {
        public static void _preOnLongClick(android.view.View.OnLongClickListener thiz, android.view.View view) {
            logOnClickEvent(view, TapBreadcrumbType.LONG_PRESS);
        }
    }
}
