/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.arch.lifecycle.ProcessLifecycleOwner;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java9.util.stream.StreamSupport;

final class EmbraceActivityService
implements ActivityService {
    private final ScheduledWorker appStateWorker = ScheduledWorker.ofSingleThread("App state service");
    private final MemoryService memoryService;
    private final CopyOnWriteArrayList<ActivityListener> listeners = new CopyOnWriteArrayList();
    private final Application application;
    private volatile WeakReference<Activity> currentActivity = new WeakReference<Object>(null);
    private volatile boolean coldStart = true;
    private volatile long startTime;
    private volatile boolean isInBackground = false;
    private final AtomicBoolean startupCompleted = new AtomicBoolean(false);

    EmbraceActivityService(Application application, MemoryService memoryService) {
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.application = (Application)Preconditions.checkNotNull((Object)application);
        this.startTime = System.currentTimeMillis();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.updateStateWithActivity(activity);
    }

    public void onActivityStarted(Activity activity) {
        this.updateStateWithActivity(activity);
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onView(activity);
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
            }
        });
    }

    public void onActivityResumed(Activity activity) {
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class) && !this.startupCompleted.getAndSet(true)) {
            StreamSupport.stream(this.listeners).forEach(listener -> {
                try {
                    listener.applicationStartupComplete();
                }
                catch (Exception ex) {
                    EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
                }
            });
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        this.updateStateWithActivity(null);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.updateStateWithActivity(null);
    }

    private synchronized void updateStateWithActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    void onForeground() {
        EmbraceLogger.logDebug("AppState: App entered foreground.");
        this.isInBackground = false;
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onForeground(this.coldStart, this.startTime);
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
            }
        });
        this.coldStart = false;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onBackground() {
        EmbraceLogger.logDebug("AppState: App entered background");
        this.isInBackground = true;
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onBackground();
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
            }
        });
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            try {
                this.memoryService.onMemoryWarning();
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to handle onTrimMemory (low memory) event", ex);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    @Override
    public boolean isInBackground() {
        return this.isInBackground;
    }

    @Override
    public Optional<Activity> getForegroundActivity() {
        return Optional.fromNullable(this.currentActivity.get());
    }

    @Override
    public void addListener(ActivityListener listener, boolean priority) {
        if (!this.listeners.contains(listener)) {
            if (priority) {
                this.listeners.add(0, listener);
            } else {
                this.listeners.addIfAbsent(listener);
            }
        }
    }

    @Override
    public void addListener(ActivityListener listener) {
        this.addListener(listener, false);
    }

    @Override
    public void removeListener(ActivityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        try {
            EmbraceLogger.logInfo("Shutting down EmbraceActivityService");
            this.application.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
            this.appStateWorker.close();
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Error when closing EmbraceActivityService", ex);
        }
    }
}

