/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Config;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.SignalQualityService;
import io.embrace.android.embracesdk.SignalStrength;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class EmbraceSignalQualityService
extends PhoneStateListener
implements SignalQualityService {
    private static final long MIN_TIME_BETWEEN_SAMPLES = 10000L;
    private final NavigableMap<Long, SignalStrength> signalStrength = new ConcurrentSkipListMap<Long, SignalStrength>();
    private final TelephonyManager telephonyManager;
    private final ConfigService configService;
    private volatile boolean signalStrengthListening = false;

    EmbraceSignalQualityService(Context context, ConfigService configService, ActivityService activityService) {
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null");
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        configService.addListener(this);
        activityService.addListener(this);
    }

    @Override
    public List<SignalStrength> getSignalMeasurements(long startTime, long endTime) {
        return new ArrayList<SignalStrength>(this.signalStrength.subMap(startTime, endTime).values());
    }

    public void onSignalStrengthsChanged(android.telephony.SignalStrength signalStrength) {
        long now = System.currentTimeMillis();
        if (this.signalStrength.isEmpty() || now - (Long)this.signalStrength.lastKey() >= 10000L) {
            SignalStrength result = SignalStrength.of(signalStrength);
            this.signalStrength.put(now, result);
        }
    }

    @Override
    public void onConfigChange(Config previousConfig, Config newConfig) {
        if (!previousConfig.getSignalStrengthEnabled().equals(newConfig.getSignalStrengthEnabled())) {
            if (newConfig.getSignalStrengthEnabled().booleanValue()) {
                this.registerPhoneStateListener();
                EmbraceLogger.logInfo("Starting signal strength listener as config was changed");
            } else {
                this.deregisterPhoneStateListener();
                EmbraceLogger.logInfo("Stopping signal strength listener as config was changed");
            }
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Stopping EmbraceSignalQualityService");
        this.deregisterPhoneStateListener();
    }

    @Override
    public void onBackground() {
        EmbraceLogger.logDebug("Pausing signal strength collection as app going to background");
        this.deregisterPhoneStateListener();
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        EmbraceLogger.logDebug("Resuming signal strength collection as app in foreground");
        this.registerPhoneStateListener();
    }

    private void registerPhoneStateListener() {
        if (this.telephonyManager != null && this.configService.getConfig().getSignalStrengthEnabled().booleanValue() && !this.signalStrengthListening) {
            try {
                this.telephonyManager.listen((PhoneStateListener)this, 256);
                this.signalStrengthListening = true;
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to register signal strength listener", ex);
            }
        }
    }

    private void deregisterPhoneStateListener() {
        if (this.telephonyManager != null && this.signalStrengthListening) {
            try {
                this.telephonyManager.listen((PhoneStateListener)this, 0);
                this.signalStrengthListening = false;
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to deregister signal strength listener", ex);
            }
        }
    }
}

