/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.fernandocejas.arrow.checks.Preconditions;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceActivityService;
import io.embrace.android.embracesdk.EmbraceEvent;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.Event;
import io.embrace.android.embracesdk.EventMessage;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.ScreenshotService;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java9.util.Maps;

final class EmbraceEventService
implements EventService,
ActivityListener {
    public static final String STARTUP_EVENT_NAME = "_startup";
    private static final long DEFAULT_LATE_THRESHOLD_MILLIS = 5000L;
    private final ApiClient apiClient;
    private final ConfigService configService;
    private final MetadataService metadataService;
    private final PerformanceInfoService performanceInfoService;
    private final UserService userService;
    private final ScreenshotService screenshotService;
    private final NavigableMap<Long, String> storyIds = new ConcurrentSkipListMap<Long, String>();
    private final ConcurrentMap<String, EventDescription> activeEvents = new ConcurrentHashMap<String, EventDescription>();
    private final ScheduledWorker lateEventWorker;

    public EmbraceEventService(ApiClient apiClient, ConfigService configService, MetadataService metadataService, PerformanceInfoService performanceInfoService, UserService userService, ScreenshotService screenshotService, EmbraceActivityService activityService) {
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.performanceInfoService = (PerformanceInfoService)Preconditions.checkNotNull((Object)performanceInfoService);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.screenshotService = (ScreenshotService)Preconditions.checkNotNull((Object)screenshotService);
        ((EmbraceActivityService)Preconditions.checkNotNull((Object)activityService)).addListener(this);
        this.lateEventWorker = ScheduledWorker.ofSingleThread("Late Event Handler");
    }

    private static String getInternalEventKey(String eventName, String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return eventName;
        }
        return String.format("%s%s%s", eventName, "#", identifier);
    }

    @Override
    public void onForeground(boolean coldStart, long startupTime) {
        if (coldStart) {
            this.startEvent(STARTUP_EVENT_NAME, null, true, null, startupTime);
        }
    }

    @Override
    public void applicationStartupComplete() {
        this.endEvent(STARTUP_EVENT_NAME);
    }

    @Override
    public void startEvent(String name) {
        this.startEvent(name, null, true);
    }

    @Override
    public void startEvent(String name, String identifier) {
        this.startEvent(name, identifier, true);
    }

    @Override
    public void startEvent(String name, String identifier, boolean allowScreenshot) {
        this.startEvent(name, identifier, allowScreenshot, null, null);
    }

    @Override
    public void startEvent(String name, String identifier, boolean allowScreenshot, Map<String, Object> properties) {
        this.startEvent(name, identifier, allowScreenshot, properties, null);
    }

    @Override
    public void startEvent(String name, String identifier, boolean allowScreenshot, Map<String, Object> properties, Long startTime) {
        try {
            Preconditions.checkArgument((!TextUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (Object)"Event name must be specified");
            if (this.configService.isEventDisabled(name)) {
                EmbraceLogger.logWarning(String.format("Event disabled. Ignoring event with name %s", name));
                return;
            }
            if (this.configService.isMessageTypeDisabled(MessageType.EVENT)) {
                EmbraceLogger.logWarning("Event message disabled. Ignoring all Events.");
                return;
            }
            if (this.lateEventWorker.isShutdown()) {
                EmbraceLogger.logError("Cannot start event as service is shut down");
                return;
            }
            String eventId = EmbraceEventService.getInternalEventKey(name, identifier);
            if (this.activeEvents.containsKey(eventId)) {
                this.endEvent(name, identifier, false);
            }
            long now = System.currentTimeMillis();
            if (startTime == null) {
                startTime = now;
            }
            Long threshold = this.calculateLateThreshold(eventId, startTime);
            String storyId = Uuid.getEmbUuid();
            this.storyIds.put(now, storyId);
            Event.Builder builder = Event.newBuilder().withStoryId(storyId).withType(EmbraceEvent.Type.START).withAppState(this.metadataService.getAppState()).withName(name).withLateThreshold(threshold).withTimestamp(now);
            if (this.metadataService.getActiveSessionId().isPresent()) {
                builder = builder.withSessionId((String)this.metadataService.getActiveSessionId().get());
            }
            if (properties != null) {
                builder = builder.withCustomProperties(properties);
            }
            Event event = builder.build();
            ScheduledFuture<?> timer = this.lateEventWorker.scheduleWithDelay(() -> this.endEvent(name, identifier, true), threshold, TimeUnit.MILLISECONDS);
            this.activeEvents.put(eventId, new EventDescription(timer, event, allowScreenshot));
            EventMessage eventMessage = EventMessage.newBuilder().withUserInfo(this.userService.getUserInfo()).withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withTelephonyInfo(this.metadataService.getTelephonyInfo()).withEvent(event).build();
            this.apiClient.sendEvent(eventMessage);
        }
        catch (Exception ex) {
            EmbraceLogger.logError(String.format("Cannot start event with name: %s, identifier: %s due to an exception", name, identifier), ex);
        }
    }

    @NonNull
    private Long calculateLateThreshold(String eventId, Long startTime) {
        Map<String, Long> limits = this.configService.getConfig().getEventLimits();
        Long threshold = (Long)Maps.getOrDefault(limits, (Object)eventId, (Object)5000L);
        long offset = Math.max(0L, System.currentTimeMillis() - startTime);
        return threshold - offset;
    }

    @Override
    public void endEvent(String name) {
        this.endEvent(name, null);
    }

    @Override
    public void endEvent(String name, String identifier) {
        this.endEvent(name, identifier, false);
    }

    private void endEvent(String name, String identifier, boolean late) {
        try {
            if (this.configService.isMessageTypeDisabled(MessageType.EVENT)) {
                EmbraceLogger.logWarning("Event message disabled. Ignoring all Events.");
                return;
            }
            String eventId = EmbraceEventService.getInternalEventKey(name, identifier);
            EventDescription eventDescription = late ? (EventDescription)this.activeEvents.get(eventId) : (EventDescription)this.activeEvents.remove(eventId);
            if (eventDescription == null) {
                EmbraceLogger.logError(String.format("No start event found when ending an event with name: %s, identifier: %s", name, identifier));
                return;
            }
            Event event = eventDescription.getEvent();
            long startTime = event.getTimestamp();
            long endTime = System.currentTimeMillis();
            long duration = Math.max(0L, endTime - startTime);
            boolean screenshotTaken = false;
            if (late && eventDescription.isAllowScreenshot() && !this.configService.isScreenshotDisabledForEvent(name)) {
                try {
                    screenshotTaken = this.screenshotService.takeScreenshotMoment(event.getStoryId());
                }
                catch (Exception ex) {
                    EmbraceLogger.logWarning("Failed to take screenshot for event " + name, ex);
                }
            } else {
                eventDescription.getLateTimer().cancel(false);
            }
            Event.Builder builder = Event.newBuilder().withStoryId(event.getStoryId()).withAppState(this.metadataService.getAppState()).withTimestamp(endTime).withDuration(duration).withName(name).withScreenshotTaken(screenshotTaken).withType(late ? EmbraceEvent.Type.LATE : EmbraceEvent.Type.END);
            if (this.metadataService.getActiveSessionId().isPresent()) {
                builder = builder.withSessionId((String)this.metadataService.getActiveSessionId().get());
            }
            EventMessage eventMessage = EventMessage.newBuilder().withPerformanceInfo(this.performanceInfoService.getPerformanceInfo(startTime, endTime)).withUserInfo(this.userService.getUserInfo()).withEvent(builder.build()).build();
            this.apiClient.sendEvent(eventMessage);
        }
        catch (Exception ex) {
            EmbraceLogger.logError(String.format("Cannot end event with name: %s, identifier: %s due to an exception", name, identifier), ex);
        }
    }

    @Override
    public List<String> findStoryIds(long startTime, long endTime) {
        return new ArrayList<String>(this.storyIds.subMap(startTime, endTime).values());
    }

    @Override
    public void close() {
        this.lateEventWorker.close();
    }

    private class EventDescription {
        private final Future<?> lateTimer;
        private final Event event;
        private final boolean allowScreenshot;

        EventDescription(Future<?> lateTimer, Event event, boolean allowScreenshot) {
            this.lateTimer = lateTimer;
            this.event = event;
            this.allowScreenshot = allowScreenshot;
        }

        public Future<?> getLateTimer() {
            return this.lateTimer;
        }

        public Event getEvent() {
            return this.event;
        }

        public boolean isAllowScreenshot() {
            return this.allowScreenshot;
        }
    }
}

