package io.embrace.android.embracesdk;

import java.io.Closeable;
import java.util.List;

/**
 * Provides information on the device signal quality, such as signal strength and SNR.
 */
interface SignalQualityService extends Closeable, ConfigListener, ActivityListener {

    /**
     * Gets the recorded measurements of signal strength within the specified time range.
     *
     * @param startTime the start time for the range of results
     * @param endTime the end time for the range of results
     * @return the list of recorded signal strength measurements for the specified period
     */
    List<SignalStrength> getSignalMeasurements(long startTime, long endTime);


}
