/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EmbraceRemoteLogger;
import io.embrace.android.embracesdk.EventService;
import io.embrace.android.embracesdk.MessageType;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.PerformanceInfoService;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.Session;
import io.embrace.android.embracesdk.SessionMessage;
import io.embrace.android.embracesdk.SessionService;
import io.embrace.android.embracesdk.UserService;
import io.embrace.android.embracesdk.Uuid;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

final class EmbraceSessionService
implements SessionService,
ActivityListener {
    public static final String APPLICATION_STATE_ACTIVE = "active";
    public static final String APPLICATION_STATE_BACKGROUND = "background";
    private static final String SESSION_START_TYPE = "st";
    private static final String SESSION_END_TYPE = "en";
    private static final String SESSION_FILE_NAME = "last_session.json";
    private final Object lock = new Object();
    private final PreferencesService preferencesService;
    private final PerformanceInfoService performanceInfoService;
    private final MetadataService metadataService;
    private final BreadcrumbService breadcrumbService;
    private final PowerService powerService;
    private final ActivityService activityService;
    private final ApiClient apiClient;
    private final EventService eventService;
    private final EmbraceRemoteLogger remoteLogger;
    private final UserService userService;
    private final ConfigService configService;
    private final CacheService cacheService;
    private final AtomicInteger sessionNumber = new AtomicInteger(0);
    private volatile ScheduledWorker sessionCacheWorker;
    private volatile Session activeSession;

    EmbraceSessionService(PreferencesService preferencesService, PerformanceInfoService performanceInfoService, MetadataService metadataService, BreadcrumbService breadcrumbService, PowerService powerService, ActivityService activityService, ApiClient apiClient, EventService eventService, EmbraceRemoteLogger remoteLogger, UserService userService, ConfigService configService, CacheService cacheService) {
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.performanceInfoService = (PerformanceInfoService)Preconditions.checkNotNull((Object)performanceInfoService);
        this.metadataService = (MetadataService)Preconditions.checkNotNull((Object)metadataService);
        this.breadcrumbService = (BreadcrumbService)Preconditions.checkNotNull((Object)breadcrumbService);
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        this.apiClient = (ApiClient)Preconditions.checkNotNull((Object)apiClient);
        this.eventService = (EventService)Preconditions.checkNotNull((Object)eventService);
        this.remoteLogger = (EmbraceRemoteLogger)Preconditions.checkNotNull((Object)remoteLogger);
        this.userService = (UserService)Preconditions.checkNotNull((Object)userService);
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService);
        this.cacheService = (CacheService)Preconditions.checkNotNull((Object)cacheService);
        this.activityService.addListener(this, true);
    }

    private void startCaching() {
        this.sessionCacheWorker = ScheduledWorker.ofSingleThread("Session Caching Service");
        this.sessionCacheWorker.scheduleAtFixedRate(this::cacheActiveSession, 0L, 5L, TimeUnit.SECONDS);
    }

    private void stopCaching() {
        this.sessionCacheWorker.close();
    }

    @Override
    public void startSession(boolean coldStart) {
        if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
            EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
            return;
        }
        String sessionId = Uuid.getEmbUuid();
        SessionMessage message = this.sessionStart(coldStart, this.sessionNumber.incrementAndGet(), sessionId);
        this.activeSession = message.getSession();
        this.metadataService.setActiveSessionId(sessionId);
        this.apiClient.sendSession(message);
        this.cacheActiveSession();
    }

    @Override
    public boolean sdkStartupFailedLastSession() {
        Optional<String> lastSessionStartupProgress = this.preferencesService.getSDKStartupStatus();
        return lastSessionStartupProgress.isPresent() && !((String)lastSessionStartupProgress.get()).equals("startup_completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCrash() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeSession != null) {
                SessionMessage sessionMessage = this.sessionEnd(this.activeSession, false, false);
                Unchecked.wrap(() -> this.apiClient.sendSession(sessionMessage).get());
                this.cacheService.deleteObject(SESSION_FILE_NAME);
            }
        }
    }

    private SessionMessage sessionStart(boolean coldStart, int number, String id) {
        Session.Builder builder = Session.newBuilder();
        if (this.powerService.getLatestBatteryLevel().isPresent()) {
            builder.withStartingBatteryLevel(((Float)this.powerService.getLatestBatteryLevel().get()).floatValue());
        }
        Session session = builder.withSessionId(id).withStartTime(System.currentTimeMillis()).withNumber(number).withColdStart(coldStart).withSessionType(SESSION_START_TYPE).build();
        return SessionMessage.newBuilder().withSession(session).withDeviceInfo(this.metadataService.getDeviceInfo()).withAppInfo(this.metadataService.getAppInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheActiveSession() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.activeSession != null) {
                    SessionMessage sessionMessage = this.sessionEnd(this.activeSession, false, true);
                    this.cacheService.cacheObject(SESSION_FILE_NAME, sessionMessage, SessionMessage.class);
                }
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Error whilst caching active session", ex);
        }
    }

    private SessionMessage sessionEnd(Session session, boolean endedCleanly, boolean forceQuit) {
        Long startTime = session.getStartTime();
        long endTime = System.currentTimeMillis();
        Session.Builder builder = Session.newBuilder(session).withEndedCleanly(endedCleanly).withLastState(this.getApplicationState()).withSessionType(SESSION_END_TYPE).withStoryIds(this.eventService.findStoryIds(startTime, endTime)).withInfoLogIds(this.remoteLogger.findInfoLogIds(startTime, endTime)).withWarningLogIds(this.remoteLogger.findWarningLogIds(startTime, endTime)).withErrorLogIds(this.remoteLogger.findErrorLogIds(startTime, endTime)).withLastHeartbeatTime(System.currentTimeMillis());
        builder = forceQuit ? builder.withTerminationTime(System.currentTimeMillis()).withReceivedTermination(true) : builder.withEndTime(endTime);
        return SessionMessage.newBuilder().withUserInfo(this.userService.getUserInfo()).withAppInfo(this.metadataService.getAppInfo()).withDeviceInfo(this.metadataService.getDeviceInfo()).withPerformanceInfo(this.performanceInfoService.getSessionPerformanceInfo(startTime, endTime)).withBreadcrumbs(this.breadcrumbService.getBreadcrumbs(startTime, endTime)).withSession(builder.build()).build();
    }

    private String getApplicationState() {
        if (this.activityService.isInBackground()) {
            return APPLICATION_STATE_BACKGROUND;
        }
        return APPLICATION_STATE_ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBackground() {
        Object object = this.lock;
        synchronized (object) {
            this.stopCaching();
            if (this.activeSession != null) {
                if (this.configService.isMessageTypeDisabled(MessageType.SESSION)) {
                    EmbraceLogger.logWarning("Session messages disabled. Ignoring all Sessions.");
                    return;
                }
                SessionMessage sessionMessage = this.sessionEnd(this.activeSession, true, false);
                this.activeSession = null;
                this.metadataService.setActiveSessionId(null);
                this.cacheService.deleteObject(SESSION_FILE_NAME);
                try {
                    this.apiClient.sendSession(sessionMessage).get();
                }
                catch (Exception ex) {
                    EmbraceLogger.logError("Failed to send session end message", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResume(boolean coldStart, boolean appInForeground, long startupTime) {
        Object object = this.lock;
        synchronized (object) {
            this.sendCachedSession();
            this.startCaching();
            this.startSession(coldStart);
            this.addViewBreadcrumbForResumedSession();
        }
    }

    private void addViewBreadcrumbForResumedSession() {
        Optional<String> screen = this.breadcrumbService.getLastViewBreadcrumbScreenName();
        if (screen.isPresent()) {
            this.breadcrumbService.forceLogView((String)screen.orNull(), System.currentTimeMillis());
        }
    }

    private void sendCachedSession() {
        Optional<SessionMessage> optionalSession = this.cacheService.loadObject(SESSION_FILE_NAME, SessionMessage.class);
        if (optionalSession.isPresent()) {
            this.apiClient.sendSession((SessionMessage)optionalSession.get());
        }
    }

    @Override
    public void close() {
        EmbraceLogger.logInfo("Shutting down EmbraceSessionService");
        this.sessionCacheWorker.close();
    }
}

