/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.SystemClock;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.ScheduledWorker;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java9.util.stream.StreamSupport;

final class EmbraceActivityService
implements ActivityService {
    private static final int MAX_STARTUP_DELAY_IN_MILLIS = 2000;
    private static final long APP_STATE_BACKGROUND_DELAY_MS = 1500L;
    private final ScheduledWorker appStateWorker = ScheduledWorker.ofSingleThread("App state service");
    private final MemoryService memoryService;
    private final List<ActivityListener> listeners = new CopyOnWriteArrayList<ActivityListener>();
    private final Application application;
    private volatile WeakReference<Activity> currentActivity = new WeakReference<Object>(null);
    private volatile long stateLastUpdatedTime = 0L;
    private volatile boolean coldStart = true;
    private volatile long startTime;

    EmbraceActivityService(Application application, MemoryService memoryService) {
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.application = (Application)Preconditions.checkNotNull((Object)application);
        this.startTime = System.currentTimeMillis();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        application.getApplicationContext().registerComponentCallbacks((ComponentCallbacks)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.onForegroundPhase(activity);
    }

    public void onActivityStarted(Activity activity) {
        StreamSupport.stream(this.listeners).forEach(listener -> {
            try {
                listener.onView(activity);
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
            }
        });
        this.onForegroundPhase(activity);
    }

    public void onActivityResumed(Activity activity) {
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class)) {
            StreamSupport.stream(this.listeners).forEach(listener -> {
                try {
                    listener.applicationStartupComplete();
                }
                catch (Exception ex) {
                    EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
                }
            });
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        this.onBackgroundPhase(activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.onBackgroundPhase(activity);
    }

    private synchronized void updateStateWithActivity(Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
        this.stateLastUpdatedTime = SystemClock.elapsedRealtime();
    }

    private synchronized void onForegroundPhase(Activity activity) {
        try {
            if (this.isInBackground()) {
                EmbraceLogger.logDebug("App entered foreground.");
                boolean foregroundSession = System.currentTimeMillis() - this.startTime <= 2000L;
                StreamSupport.stream(this.listeners).forEach(listener -> {
                    try {
                        listener.onResume(this.coldStart, foregroundSession, this.startTime);
                    }
                    catch (Exception ex) {
                        EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
                    }
                });
                this.coldStart = false;
            }
            this.updateStateWithActivity(activity);
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Error handling foregrounding event", ex);
        }
    }

    private synchronized void onBackgroundPhase(Activity activity) {
        try {
            if (activity == this.currentActivity.get()) {
                this.updateStateWithActivity(null);
                this.appStateWorker.scheduleWithDelay(() -> {
                    if (this.isInBackground()) {
                        EmbraceLogger.logDebug("App entered background");
                        StreamSupport.stream(this.listeners).forEach(listener -> {
                            try {
                                listener.onBackground();
                            }
                            catch (Exception ex) {
                                EmbraceLogger.logWarning("Failed to notify EmbraceActivityService listener", ex);
                            }
                        });
                    }
                }, 1500L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Error handling backgrounding event", ex);
        }
    }

    public void onTrimMemory(int trimLevel) {
        if (trimLevel == 10) {
            try {
                this.memoryService.onMemoryWarning();
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Failed to handle onTrimMemory (low memory) event", ex);
            }
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    @Override
    public boolean isInBackground() {
        return this.currentActivity.get() == null && SystemClock.elapsedRealtime() - this.stateLastUpdatedTime >= 1500L;
    }

    @Override
    public Optional<Activity> getForegroundActivity() {
        return Optional.fromNullable(this.currentActivity.get());
    }

    @Override
    public void addListener(ActivityListener listener, boolean priority) {
        if (priority) {
            this.listeners.add(0, listener);
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public void addListener(ActivityListener listener) {
        this.addListener(listener, false);
    }

    @Override
    public void removeListener(ActivityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
        try {
            EmbraceLogger.logInfo("Shutting down EmbraceActivityService");
            this.application.getApplicationContext().unregisterComponentCallbacks((ComponentCallbacks)this);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
            this.appStateWorker.close();
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Error when closing EmbraceActivityService", ex);
        }
    }
}

