/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Pair;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.Breadcrumb;
import io.embrace.android.embracesdk.BreadcrumbService;
import io.embrace.android.embracesdk.Breadcrumbs;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.CustomBreadcrumb;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.TapBreadcrumb;
import io.embrace.android.embracesdk.ViewBreadcrumb;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

class EmbraceBreadcrumbService
implements BreadcrumbService,
ActivityListener {
    private static final Integer DEFAULT_BREADCRUMB_LIMIT = 100;
    private final ConfigService configService;
    private final LinkedBlockingDeque<ViewBreadcrumb> viewBreadcrumbs = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<TapBreadcrumb> tapBreadcrumbs = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<CustomBreadcrumb> customBreadcrumbs = new LinkedBlockingDeque();

    EmbraceBreadcrumbService(ConfigService configService, ActivityService activityService) {
        this.configService = (ConfigService)Preconditions.checkNotNull((Object)configService, (Object)"configService must not be null");
        Preconditions.checkNotNull((Object)activityService, (Object)"activityService must not be null");
        activityService.addListener(this);
    }

    @Override
    public void logView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, false);
    }

    @Override
    public void forceLogView(String screen, long timestamp) {
        this.addToViewLogsQueue(screen, timestamp, true);
    }

    @Override
    public void logTap(Pair<Float, Float> point, String element, long timestamp, TapBreadcrumb.TapBreadcrumbType type) {
        try {
            this.tapBreadcrumbs.push(new TapBreadcrumb(point, element, timestamp, type));
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Failed to log tap breadcrumb for element " + element);
        }
    }

    @Override
    public void logCustom(String message, long timestamp) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            EmbraceLogger.logWarning("Breadcrumb message must not be blank");
            return;
        }
        try {
            this.customBreadcrumbs.push(new CustomBreadcrumb(message, timestamp));
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Failed to log custom breadcrumb with messdage " + message, ex);
        }
    }

    @Override
    public List<ViewBreadcrumb> getViewBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.viewBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<TapBreadcrumb> getTapBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.tapBreadcrumbs, startTime, endTime);
    }

    @Override
    public List<CustomBreadcrumb> getCustomBreadcrumbsForSession(long startTime, long endTime) {
        return this.filterBreadcrumbsForTimeWindow(this.customBreadcrumbs, startTime, endTime);
    }

    @Override
    public Breadcrumbs getBreadcrumbs(long start, long end) {
        return Breadcrumbs.newBuilder().withCustomBreadcrumbs(this.getCustomBreadcrumbsForSession(start, end)).withTapBreadcrumbs(this.getTapBreadcrumbsForSession(start, end)).withViewBreadcrumbs(this.getViewBreadcrumbsForSession(start, end)).build();
    }

    @Override
    public Optional<String> getLastViewBreadcrumbScreenName() {
        if (this.viewBreadcrumbs.isEmpty()) {
            return Optional.absent();
        }
        return this.viewBreadcrumbs.peek().getScreen();
    }

    @Override
    public void onView(Activity activity) {
        this.logView(activity.getClass().getName(), System.currentTimeMillis());
    }

    private synchronized void addToViewLogsQueue(String screen, long timestamp, boolean force) {
        try {
            ViewBreadcrumb lastViewBreadcrumb = this.viewBreadcrumbs.peek();
            if (force || lastViewBreadcrumb == null || !((String)lastViewBreadcrumb.getScreen().or((Object)"")).equalsIgnoreCase(String.valueOf(screen))) {
                this.viewBreadcrumbs.push(new ViewBreadcrumb(screen, timestamp));
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logError("Failed to add view breadcrumb for " + screen, ex);
        }
    }

    private <T extends Breadcrumb> List<T> filterBreadcrumbsForTimeWindow(Deque<T> breadcrumbs, long startTime, long endTime) {
        int limit = (Integer)this.configService.getConfig().getBreadcrumbLimit().or((Object)DEFAULT_BREADCRUMB_LIMIT);
        return (List)StreamSupport.stream(breadcrumbs).filter(breadcrumb -> breadcrumb.getTimestamp() >= startTime).filter(breadcrumb -> endTime <= 0L || breadcrumb.getTimestamp() <= endTime).limit((long)limit).collect(Collectors.toList());
    }
}

