/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.PreferencesService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class UserInfo {
    static final String PERSONA_NEW_USER = "new_user";
    static final String PERSONA_POWER_USER = "power_user";
    static final String PERSONA_LOGGED_IN = "logged_in";
    static final String PERSONA_VIP = "vip";
    static final String PERSONA_CREATOR = "content_creator";
    static final String PERSONA_TESTER = "tester";
    static final String PERSONA_PAYER = "payer";
    static final String PERSONA_FIRST_DAY_USER = "first_day";
    @SerializedName(value="id")
    private final String userId;
    @SerializedName(value="em")
    private final String email;
    @SerializedName(value="un")
    private final String username;
    @SerializedName(value="per")
    private final Set<String> personas;

    private UserInfo(Builder builder) {
        this.userId = builder.userId;
        this.email = builder.email;
        this.username = builder.username;
        this.personas = builder.personas;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(UserInfo copy) {
        Builder builder = new Builder();
        builder.userId = copy.getUserId();
        builder.email = copy.getEmail();
        builder.username = copy.getUsername();
        builder.personas = copy.getPersonas();
        return builder;
    }

    UserInfo(String userId, String email, String username, Set<String> personas) {
        this.userId = userId;
        this.email = email;
        this.username = username;
        this.personas = personas;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUsername() {
        return this.username;
    }

    public Set<String> getPersonas() {
        return this.personas;
    }

    public static UserInfo ofEmpty() {
        return new UserInfo(null, null, null, null);
    }

    public static UserInfo ofStored(PreferencesService preferencesService, ConfigService configService) {
        Builder builder = UserInfo.newBuilder();
        HashSet<String> personas = new HashSet<String>();
        if (preferencesService.getUserEmailAddress().isPresent()) {
            builder = builder.withEmail((String)preferencesService.getUserEmailAddress().get());
        }
        if (preferencesService.getUserIdentifier().isPresent()) {
            builder = builder.withUserId((String)preferencesService.getUserIdentifier().get());
        }
        if (preferencesService.getUsername().isPresent()) {
            builder = builder.withUsername((String)preferencesService.getUsername().get());
        }
        if (preferencesService.getUserPersonas().isPresent()) {
            personas.addAll((Collection)preferencesService.getUserPersonas().get());
        }
        if (preferencesService.getCustomPersonas().isPresent()) {
            personas.addAll((Collection)preferencesService.getCustomPersonas().get());
        }
        personas.remove(PERSONA_PAYER);
        if (preferencesService.getUserPayer()) {
            personas.add(PERSONA_PAYER);
        }
        personas.remove(PERSONA_FIRST_DAY_USER);
        if (preferencesService.isUsersFirstDay()) {
            personas.add(PERSONA_FIRST_DAY_USER);
        }
        personas.addAll(configService.getConfig().getAppPersonas());
        builder = builder.withPersonas(personas);
        return builder.build();
    }

    public static final class Builder {
        private String userId;
        private String email;
        private String username;
        private Set<String> personas;

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPersonas(Set<String> personas) {
            this.personas = personas;
            return this;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getEmail() {
            return this.email;
        }

        public String getUsername() {
            return this.username;
        }

        public Set<String> getPersonas() {
            return this.personas;
        }

        public UserInfo build() {
            return new UserInfo(this);
        }
    }
}

