/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ApiRequest;
import io.embrace.android.embracesdk.CacheService;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.ScheduledWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

class ApiClientRetryWorker<T> {
    private final Class<T> clazz;
    private final CacheService cacheService;
    private final Queue<FailedApiCall<T>> failedApiCalls = new ConcurrentLinkedQueue<FailedApiCall<T>>();
    private final String cacheKey;
    private final ApiClient apiClient;
    private final ScheduledWorker worker;

    ApiClientRetryWorker(Class<T> clazz, CacheService cacheService, ApiClient apiClient, ScheduledWorker worker) {
        this.clazz = clazz;
        this.cacheService = cacheService;
        this.apiClient = apiClient;
        this.cacheKey = "network_failed_" + clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.worker = worker;
        this.start();
    }

    void retryCall(ApiRequest request, T payload) {
        this.failedApiCalls.add(new FailedApiCall<T>(request, payload));
    }

    private void start() {
        Optional<FailedApiCalls> optionalCalls = this.cacheService.loadObject(this.cacheKey, FailedApiCalls.class);
        if (optionalCalls.isPresent()) {
            this.failedApiCalls.addAll(((FailedApiCalls)optionalCalls.get()).failedApiCalls);
        }
        this.worker.scheduleAtFixedRate(() -> {
            try {
                ArrayList reattempt = new ArrayList();
                FailedApiCall<T> lastCall = this.failedApiCalls.poll();
                while (lastCall != null) {
                    reattempt.add(lastCall);
                    lastCall = this.failedApiCalls.poll();
                }
                this.cacheService.cacheObject(this.cacheKey, new FailedApiCalls(reattempt), FailedApiCalls.class);
                for (FailedApiCall failedApiCall : reattempt) {
                    this.apiClient.jsonPost(failedApiCall.apiRequest, failedApiCall.payload, this.clazz, this::retryCall);
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logError("Error in ApiClient retry worker", ex);
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private static class FailedApiCalls<P> {
        private final List<FailedApiCall<P>> failedApiCalls;

        FailedApiCalls(List<FailedApiCall<P>> failedApiCalls) {
            this.failedApiCalls = failedApiCalls;
        }
    }

    private static class FailedApiCall<P> {
        private final ApiRequest apiRequest;
        private final P payload;

        FailedApiCall(ApiRequest apiRequest, P payload) {
            this.apiRequest = apiRequest;
            this.payload = payload;
        }
    }
}

