package io.embrace.android.embracesdk;

import android.telephony.TelephonyManager;

import com.google.gson.annotations.SerializedName;

/**
 * Device telephony information from the Android {@link TelephonyManager}.
 */
final class TelephonyInfo {
    @SerializedName("cn")
    private final String carrierName;

    @SerializedName("ci")
    private final String carrierCountry;

    @SerializedName("cc")
    private final String mcc;

    @SerializedName("ce")
    private final String mnc;

    public TelephonyInfo(String carrierName, String carrierCountry, String mcc, String mnc) {
        this.carrierName = carrierName;
        this.carrierCountry = carrierCountry;
        this.mcc = mcc;
        this.mnc = mnc;
    }
}
