package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

final class DeviceInfo {
    @SerializedName("dm")
    private final String manufacturer;

    @SerializedName("do")
    private final String model;

    @SerializedName("da")
    private final String architecture;

    @SerializedName("jb")
    private final Boolean jailbroken;

    @SerializedName("lc")
    private final String locale;

    @SerializedName("ms")
    private final Long internalStorageTotalCapacity;

    @SerializedName("os")
    private final String operatingSystemType;

    @SerializedName("ov")
    private final String operatingSystemVersion;

    @SerializedName("oc")
    private final Integer operatingSystemVersionCode;

    @SerializedName("sr")
    private final String screenResolution;

    @SerializedName("tz")
    private final String timezoneDescription;

    @SerializedName("up")
    private final Long uptime;

    private DeviceInfo(Builder builder) {
        manufacturer = builder.manufacturer;
        model = builder.model;
        architecture = builder.architecture;
        jailbroken = builder.jailbroken;
        locale = builder.locale;
        internalStorageTotalCapacity = builder.internalStorageTotalCapacity;
        operatingSystemType = builder.operatingSystemType;
        operatingSystemVersion = builder.operatingSystemVersion;
        operatingSystemVersionCode = builder.operatingSystemVersionCode;
        screenResolution = builder.screenResolution;
        timezoneDescription = builder.timezoneDescription;
        uptime = builder.uptime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }


    public static final class Builder {
        private String manufacturer;
        private String model;
        private String architecture;
        private Boolean jailbroken;
        private String locale;
        private Long internalStorageTotalCapacity;
        private String operatingSystemType;
        private String operatingSystemVersion;
        private Integer operatingSystemVersionCode;
        private String screenResolution;
        private String timezoneDescription;
        private Long uptime;

        private Builder() {
        }

        public Builder withManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public Builder withJailbroken(Boolean jailbroken) {
            this.jailbroken = jailbroken;
            return this;
        }

        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder withInternalStorageTotalCapacity(Long internalStorageTotalCapacity) {
            this.internalStorageTotalCapacity = internalStorageTotalCapacity;
            return this;
        }

        public Builder withOperatingSystemType(String operatingSystemType) {
            this.operatingSystemType = operatingSystemType;
            return this;
        }

        public Builder withOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public Builder withOperatingSystemVersionCode(Integer operatingSystemVersionCode) {
            this.operatingSystemVersionCode = operatingSystemVersionCode;
            return this;
        }

        public Builder withScreenResolution(String screenResolution) {
            this.screenResolution = screenResolution;
            return this;
        }

        public Builder withTimezoneDescription(String timezoneDescription) {
            this.timezoneDescription = timezoneDescription;
            return this;
        }

        public Builder withUptime(Long uptime) {
            this.uptime = uptime;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this);
        }
    }
}
