package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * Describes a Crash (uncaught {@link Throwable} by a unique ID, and a list of exceptions (causes).
 */
final class Crash {
    @SerializedName("id")
    private final String id;

    @SerializedName("ex")
    private final List<ExceptionInfo> exceptions;

    Crash(String id, List<ExceptionInfo> exceptions) {
        this.id = id;
        this.exceptions = exceptions;
    }

    /**
     * Creates a crash from a {@link Throwable}. Extracts each cause and converts it to
     * {@link ExceptionInfo}.
     *
     * @param throwable the throwable to parse
     * @return a crash
     */
    public static Crash ofThrowable(Throwable throwable) {
        return new Crash(Uuid.getEmbUuid(), exceptionInfo(throwable));
    }

    private static List<ExceptionInfo> exceptionInfo(Throwable ex) {
        List<ExceptionInfo> result = new ArrayList<>();
        Throwable throwable = ex;
        while (throwable != null && !throwable.equals(throwable.getCause())) {
            ExceptionInfo exceptionInfo = ExceptionInfo.ofThrowable(throwable);
            result.add(0, exceptionInfo);
            throwable = throwable.getCause();
        }
        return result;
    }
}
