/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.app.usage.StorageStatsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.WindowManager;
import com.fernandocejas.arrow.checks.Preconditions;
import com.fernandocejas.arrow.optional.Optional;
import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.AppInfo;
import io.embrace.android.embracesdk.BuildInfo;
import io.embrace.android.embracesdk.CpuService;
import io.embrace.android.embracesdk.DeviceInfo;
import io.embrace.android.embracesdk.DiskUsage;
import io.embrace.android.embracesdk.EmbraceLogger;
import io.embrace.android.embracesdk.EventPerformanceInfo;
import io.embrace.android.embracesdk.MemoryService;
import io.embrace.android.embracesdk.MetadataService;
import io.embrace.android.embracesdk.MetadataUtils;
import io.embrace.android.embracesdk.NetworkService;
import io.embrace.android.embracesdk.PerformanceInfo;
import io.embrace.android.embracesdk.PowerService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.SessionPerformanceInfo;
import io.embrace.android.embracesdk.TelephonyInfo;

final class EmbraceMetadataService
implements MetadataService,
ActivityListener {
    private static final String UNKNOWN_VALUE = "UNKNOWN";
    private final TelephonyManager telephonyManager;
    private final WindowManager windowManager;
    private final PackageManager packageManager;
    private final StorageStatsManager storageStatsManager;
    private final PowerService powerService;
    private final MemoryService memoryService;
    private final ApplicationInfo applicationInfo;
    private final CpuService cpuService;
    private final NetworkService networkService;
    private final PreferencesService preferencesService;
    private final AnrService anrService;
    private final ActivityService activityService;
    private final BuildInfo buildInfo;
    private final String deviceId;
    private final String packageName;
    private final String appVersionName;
    private final String appVersionCode;
    private final StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
    private final boolean appUpdated;
    private final boolean osUpdated;
    private volatile String activeSessionId;

    private EmbraceMetadataService(TelephonyManager telephonyManager, WindowManager windowManager, PackageManager packageManager, StorageStatsManager storageStatsManager, PowerService powerService, MemoryService memoryService, CpuService cpuService, NetworkService networkService, AnrService anrService, BuildInfo buildInfo, ApplicationInfo applicationInfo, String deviceId, String packageName, String appVersionName, String appVersionCode, boolean appUpdated, boolean osUpdated, PreferencesService preferencesService, ActivityService activityService) {
        this.telephonyManager = telephonyManager;
        this.windowManager = windowManager;
        this.packageManager = packageManager;
        this.storageStatsManager = storageStatsManager;
        this.powerService = (PowerService)Preconditions.checkNotNull((Object)powerService);
        this.memoryService = (MemoryService)Preconditions.checkNotNull((Object)memoryService);
        this.cpuService = (CpuService)Preconditions.checkNotNull((Object)cpuService);
        this.networkService = (NetworkService)Preconditions.checkNotNull((Object)networkService);
        this.anrService = (AnrService)Preconditions.checkNotNull((Object)anrService);
        this.buildInfo = (BuildInfo)Preconditions.checkNotNull((Object)buildInfo);
        this.applicationInfo = applicationInfo;
        this.deviceId = (String)Preconditions.checkNotNull((Object)deviceId);
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName);
        this.appVersionName = (String)Preconditions.checkNotNull((Object)appVersionName);
        this.appVersionCode = (String)Preconditions.checkNotNull((Object)appVersionCode);
        this.appUpdated = appUpdated;
        this.osUpdated = osUpdated;
        this.preferencesService = (PreferencesService)Preconditions.checkNotNull((Object)preferencesService);
        this.activityService = (ActivityService)Preconditions.checkNotNull((Object)activityService);
        activityService.addListener(this);
    }

    static EmbraceMetadataService ofContext(Context context, PowerService powerService, MemoryService memoryService, CpuService cpuService, NetworkService networkService, AnrService anrService, BuildInfo buildInfo, PreferencesService preferencesService, ActivityService activityService) {
        String appVersionCode;
        String appVersionName;
        Preconditions.checkNotNull((Object)context, (Object)"Device context is null");
        StorageStatsManager storageStatsManager = null;
        if (Build.VERSION.SDK_INT >= 26) {
            storageStatsManager = (StorageStatsManager)context.getSystemService("storagestats");
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            appVersionName = String.valueOf(packageInfo.versionName);
            appVersionCode = String.valueOf(packageInfo.versionCode);
        }
        catch (Exception e) {
            appVersionName = UNKNOWN_VALUE;
            appVersionCode = UNKNOWN_VALUE;
        }
        Optional<String> lastKnownAppVersion = preferencesService.getAppVersion();
        boolean isAppUpdated = lastKnownAppVersion.isPresent() && !((String)lastKnownAppVersion.get()).equalsIgnoreCase(appVersionName);
        Optional<String> lastKnownOsVersion = preferencesService.getOsVersion();
        boolean isOsUpdated = lastKnownOsVersion.isPresent() && !((String)lastKnownOsVersion.get()).equalsIgnoreCase(String.valueOf(Build.VERSION.RELEASE));
        return new EmbraceMetadataService((TelephonyManager)context.getSystemService("phone"), (WindowManager)context.getSystemService("window"), context.getPackageManager(), storageStatsManager, powerService, memoryService, cpuService, networkService, anrService, buildInfo, context.getApplicationInfo(), MetadataUtils.createDeviceId(context.getContentResolver()), context.getPackageName(), appVersionName, appVersionCode, isAppUpdated, isOsUpdated, preferencesService, activityService);
    }

    @Override
    public TelephonyInfo getTelephonyInfo() {
        String mcc = null;
        String mnc = null;
        String carrierName = null;
        String carrierCountry = null;
        if (this.telephonyManager != null) {
            try {
                String networkOperator = this.telephonyManager.getNetworkOperator();
                carrierName = this.telephonyManager.getNetworkOperatorName();
                carrierCountry = this.telephonyManager.getNetworkCountryIso();
                if (!(TextUtils.isEmpty((CharSequence)networkOperator) || networkOperator.length() != 5 && networkOperator.length() != 6)) {
                    mcc = networkOperator.substring(0, 3);
                    mnc = networkOperator.substring(3);
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logWarning("Could not retrieve telephony information", ex);
            }
        }
        return new TelephonyInfo(carrierName, carrierCountry, mcc, mnc);
    }

    @Override
    public EventPerformanceInfo getPerformanceInfo(long startTime, long endTime) {
        EventPerformanceInfo.Builder builder = EventPerformanceInfo.newBuilder().withNetworkCalls(this.networkService.getNetworkCalls(startTime, endTime));
        this.addPerformanceInfo(builder, startTime, endTime);
        return builder.build();
    }

    @Override
    public SessionPerformanceInfo getSessionPerformanceInfo(long startTime, long lastKnownTime) {
        SessionPerformanceInfo.Builder builder = SessionPerformanceInfo.newBuilder().withNetworkSession(this.networkService.getNetworkSession(startTime, lastKnownTime));
        builder.withAnrIntervals(this.anrService.getAnrIntervals(startTime, lastKnownTime));
        this.addPerformanceInfo(builder, startTime, lastKnownTime);
        return builder.build();
    }

    @Override
    public Optional<String> getAppVersionCodeForRequest() {
        return MetadataUtils.getVersionCodeForRequest(this.packageManager, this.packageName);
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getAppVersionCode() {
        return this.appVersionCode;
    }

    @Override
    public String getAppVersionName() {
        return this.appVersionName;
    }

    private <T extends PerformanceInfo.Builder> void addPerformanceInfo(T builder, long startTime, long endTime) {
        builder.withBatteryMeasurements(this.powerService.getBatteryMeasurements(startTime, endTime)).withChargingIntervals(this.powerService.getChargingIntervals(startTime, endTime)).withCriticalCpuIntervals(this.cpuService.getCpuCriticalIntervals(startTime, endTime)).withDiskUsage(this.diskUsage()).withMemorySamples(this.memoryService.getMemorySamples(startTime, endTime)).withMemoryWarnings(this.memoryService.getMemoryWarnings(startTime, endTime)).withNetworkInterfaceIntervals(this.networkService.getNetworkInterfaceIntervals(startTime, endTime));
        if (this.powerService.getLatestBatteryLevel().isPresent()) {
            builder.withBatteryLevel(((Float)this.powerService.getLatestBatteryLevel().get()).floatValue());
        }
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return DeviceInfo.newBuilder().withManufacturer(MetadataUtils.getDeviceManufacturer()).withModel(MetadataUtils.getModel()).withArchitecture(MetadataUtils.getArchitecture()).withJailbroken(MetadataUtils.isJailbroken()).withLocale(MetadataUtils.getLocale()).withInternalStorageTotalCapacity(MetadataUtils.getInternalStorageTotalCapacity(this.statFs)).withOperatingSystemType(MetadataUtils.getOperatingSystemType()).withOperatingSystemVersion(MetadataUtils.getOperatingSystemVersion()).withOperatingSystemVersionCode(MetadataUtils.getOperatingSystemVersionCode()).withScreenResolution((String)MetadataUtils.getScreenResolution(this.windowManager).orNull()).withTimezoneDescription(MetadataUtils.getTimezoneId()).withUptime(MetadataUtils.getSystemUptime()).build();
    }

    @Override
    public AppInfo getAppInfo() {
        return AppInfo.newBuilder().withSdkVersion(String.valueOf("3.0.2")).withSdkSimpleVersion(String.valueOf(52)).withBuildId(this.buildInfo.getBuildId()).withAppVersion(this.appVersionName).withBundleVersion(this.appVersionCode).withEnvironment(MetadataUtils.appEnvironment(this.applicationInfo)).withAppUpdated(this.appUpdated).withOsUpdated(this.osUpdated).withAppUpdatedThisLaunch(this.appUpdated).withOsUpdatedThisLaunch(this.osUpdated).build();
    }

    @Override
    public boolean isDebug() {
        return MetadataUtils.isDebug(this.applicationInfo);
    }

    @Override
    public String getAppId() {
        return this.buildInfo.getAppId();
    }

    @Override
    public boolean isAppUpdated() {
        return this.appUpdated;
    }

    @Override
    public boolean isOsUpdated() {
        return this.osUpdated;
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void setActiveSessionId(String sessionId) {
        this.activeSessionId = sessionId;
    }

    @Override
    public Optional<String> getActiveSessionId() {
        return Optional.fromNullable((Object)this.activeSessionId);
    }

    @Override
    public String getAppState() {
        if (this.activityService.isInBackground()) {
            return "background";
        }
        return "active";
    }

    private DiskUsage diskUsage() {
        Optional<Long> usage;
        long free = MetadataUtils.getInternalStorageFreeCapacity(this.statFs);
        if (Build.VERSION.SDK_INT >= 26 && (usage = MetadataUtils.getDeviceDiskAppUsage(this.storageStatsManager, this.packageManager, this.packageName)).isPresent()) {
            return new DiskUsage((Long)usage.get(), free);
        }
        return new DiskUsage(free);
    }

    @Override
    public void applicationStartupComplete() {
        String appVersion = this.getAppVersionName();
        String osVersion = String.valueOf(Build.VERSION.RELEASE);
        String deviceId = this.getDeviceId();
        long installDate = System.currentTimeMillis();
        String log = String.format("Setting metadata on preferences service. App version: {}, OS version {}, device ID: {}, install date: {}", appVersion, osVersion, deviceId, installDate);
        EmbraceLogger.logDebug(log);
        this.preferencesService.setAppVersion(appVersion);
        this.preferencesService.setOsVersion(osVersion);
        this.preferencesService.setDeviceIdentifier(deviceId);
        if (!this.preferencesService.getInstallDate().isPresent()) {
            this.preferencesService.setInstallDate(installDate);
        }
    }
}

