package io.embrace.android.embracesdk;

import java.io.Closeable;

interface SessionService extends Closeable {
    /**
     * Starts a new session.
     *
     * @param coldStart whether this is a cold start of the application
     */
    void startSession(boolean coldStart);

    /**
     * Based on the SDK STARTUP STATUS preference key , it analyzes if the startup failed during
     * last session.
     *
     * @return if the SDK startup failed last session.
     */
    boolean sdkStartupFailedLastSession();


    /**
     * Handles an uncaught exception, ending the session and saving the session to disk.
     */
    void handleCrash();
}
