package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.List;

final class NetworkTimeline {
    @SerializedName("rq")
    private final List<NetworkRequest> requests;

    @SerializedName("rc")
    private final int requestCount;

    public NetworkTimeline(List<NetworkRequest> requests, int requestCount) {
        this.requests = requests;
        this.requestCount = requestCount;
    }

    static class NetworkRequest {
        @SerializedName("rc")
        private final Integer statusCode;

        @SerializedName("st")
        private final long startTime;

        @SerializedName("dur")
        private final long duration;

        NetworkRequest(Integer statusCode, long startTime, long duration) {
            this.statusCode = statusCode;
            this.startTime = startTime;
            this.duration = duration;
        }
    }
}
