package io.embrace.android.embracesdk;

import android.app.Activity;

/**
 * Listener implemented by observers of the {@link ActivityService}.
 */
interface ActivityListener {

    /**
     * Triggered when the app enters the background.
     */
    default void onBackground() {

    }

    /**
     * Triggered when the application is resumed.
     *
     * @param coldStart   whether this is a cold start
     * @param startupTime the timestamp at which the application started
     */

    default void onForeground(boolean coldStart, long startupTime) {

    }

    /**
     * Triggered when the application has completed startup;
     */
    default void applicationStartupComplete() {

    }

    /**
     * Triggered when a view is opened.
     *
     * @param activity details of the activity
     */
    default void onView(Activity activity) {

    }
}
