/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import io.embrace.android.embracesdk.AnrInterval;
import io.embrace.android.embracesdk.AnrService;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class EmbraceAnrService
implements AnrService {
    private final int MONITORING_INTERVAL = 200;
    private final long ANR_THRESHOLD_INTERVAL = 1000L;
    static final int HEALTHCHECK_EXECUTE = 34592;
    static final int HEALTHCHECK_REQUEST = 34593;
    static final int HEALTHCHECK_RESPONSE = 34594;
    private final NavigableMap<Long, AnrInterval> anrIntervals = new ConcurrentSkipListMap<Long, AnrInterval>();
    private final MainThreadHandler mainThreadHandler;
    private final MonitoringThreadHandler monitoringThreadHandler;
    private final HandlerThread monitoringThread = new HandlerThread("Embrace ANR Healthcheck");
    private volatile long lastAlive;
    private volatile boolean anrInProgress;

    EmbraceAnrService() {
        this.monitoringThread.start();
        Looper callingThreadLooper = this.monitoringThread.getLooper();
        this.monitoringThreadHandler = new MonitoringThreadHandler(callingThreadLooper);
        this.mainThreadHandler = new MainThreadHandler(Looper.getMainLooper());
        this.monitoringThreadHandler.runHealthcheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnrInterval> getAnrIntervals(long startTime, long endTime) {
        EmbraceAnrService embraceAnrService = this;
        synchronized (embraceAnrService) {
            Collection<AnrInterval> intervals = this.anrIntervals.subMap(startTime, endTime).values();
            ArrayList<AnrInterval> results = new ArrayList<AnrInterval>();
            results.addAll(intervals);
            if (this.anrInProgress) {
                results.add(new AnrInterval(this.lastAlive, this.lastAlive, null, AnrInterval.Type.UI));
            }
            return results;
        }
    }

    @Override
    public void close() {
        try {
            this.monitoringThread.quit();
            this.monitoringThread.join();
        }
        catch (Exception ex) {
            EmbraceLogger.logWarning("Failed to cleanly shut down EmbraceAnrService");
        }
    }

    class MainThreadHandler
    extends Handler {
        public MainThreadHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            try {
                if (msg.what == 34593) {
                    EmbraceAnrService.this.monitoringThreadHandler.sendMessage(this.obtainMessage(34594));
                }
            }
            catch (Exception ex) {
                EmbraceLogger.logError("ANR healthcheck failed in main (monitored) thread", ex);
            }
            super.handleMessage(msg);
        }
    }

    class MonitoringThreadHandler
    extends Handler {
        public MonitoringThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            block9: {
                try {
                    boolean anrThresholdExceeded;
                    long timestamp = System.currentTimeMillis();
                    boolean bl = anrThresholdExceeded = EmbraceAnrService.this.lastAlive > 0L && timestamp - EmbraceAnrService.this.lastAlive > 1000L;
                    if (msg.what == 34594) {
                        if (anrThresholdExceeded) {
                            EmbraceLogger.logDebug("Main thread recovered from not responding for > 1s");
                            EmbraceAnrService embraceAnrService = EmbraceAnrService.this;
                            synchronized (embraceAnrService) {
                                EmbraceAnrService.this.anrIntervals.put(timestamp, new AnrInterval(EmbraceAnrService.this.lastAlive, EmbraceAnrService.this.lastAlive, timestamp, AnrInterval.Type.UI));
                            }
                        }
                        EmbraceAnrService.this.lastAlive = timestamp;
                        EmbraceAnrService.this.anrInProgress = false;
                        break block9;
                    }
                    if (msg.what == 34592) {
                        if (anrThresholdExceeded && !EmbraceAnrService.this.anrInProgress) {
                            EmbraceLogger.logDebug("Main thread not responding for > 1s");
                            EmbraceAnrService.this.anrInProgress = true;
                        }
                        this.runHealthcheck();
                    }
                }
                catch (Exception ex) {
                    EmbraceLogger.logError("ANR healthcheck failed in monitoring thread", ex);
                }
            }
        }

        void runHealthcheck() {
            EmbraceAnrService.this.mainThreadHandler.sendMessage(this.obtainMessage(34593));
            EmbraceAnrService.this.monitoringThreadHandler.sendMessageDelayed(this.obtainMessage(34592), 200L);
        }
    }
}

