/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.ActivityListener;
import io.embrace.android.embracesdk.ActivityService;
import io.embrace.android.embracesdk.ApiClient;
import io.embrace.android.embracesdk.ConfigService;
import io.embrace.android.embracesdk.PreferencesService;
import io.embrace.android.embracesdk.UserInfo;
import io.embrace.android.embracesdk.UserService;
import java.util.HashSet;

class EmbraceUserService
implements ActivityListener,
UserService {
    private final PreferencesService preferencesService;
    private final ConfigService configService;
    private final ApiClient apiClient;
    private volatile UserInfo userInfo = UserInfo.ofEmpty();

    EmbraceUserService(ActivityService activityService, ConfigService configService, PreferencesService preferencesService, ApiClient apiClient) {
        this.configService = configService;
        this.preferencesService = preferencesService;
        this.apiClient = apiClient;
        activityService.addListener(this);
    }

    @Override
    public void applicationStartupComplete() {
        this.userInfo = UserInfo.ofStored(this.preferencesService, this.configService);
        this.apiClient.sendUser(this.userInfo);
    }

    @Override
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    @Override
    public void setUserIdentifier(String userId) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withUserId(userId).build();
        this.preferencesService.setUserIdentifier(userId);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void clearUserIdentifier() {
        this.setUserIdentifier(null);
    }

    @Override
    public void setUserEmail(String email) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withEmail(email).build();
        this.preferencesService.setUserEmailAddress(email);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void clearUserEmail() {
        this.setUserEmail(null);
    }

    @Override
    public void setUserAsPayer() {
        this.setUserPersona("payer");
    }

    @Override
    public void clearUserAsPayer() {
        this.clearUserPersona("payer");
    }

    @Override
    public void setUserPersona(String persona) {
        UserInfo newUserInfo;
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.add(persona);
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
        this.preferencesService.setUserPersonas(personas);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void clearUserPersona(String persona) {
        UserInfo newUserInfo;
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (builder.getPersonas() != null) {
            personas.addAll(builder.getPersonas());
        }
        personas.remove(persona);
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
        this.preferencesService.setUserPersonas(personas);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void clearAllUserPersonas() {
        UserInfo newUserInfo;
        UserInfo.Builder builder = UserInfo.newBuilder(this.userInfo);
        HashSet<String> personas = new HashSet<String>();
        if (this.preferencesService.getUserPayer()) {
            personas.add("payer");
        }
        if (this.preferencesService.isUsersFirstDay()) {
            personas.add("first_day");
        }
        this.userInfo = newUserInfo = builder.withPersonas(personas).build();
        this.preferencesService.setUserPersonas(personas);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void setUsername(String username) {
        UserInfo newUserInfo;
        this.userInfo = newUserInfo = UserInfo.newBuilder(this.userInfo).withUsername(username).build();
        this.preferencesService.setUsername(username);
        this.apiClient.sendUser(newUserInfo);
    }

    @Override
    public void clearUsername() {
        this.setUsername(null);
    }
}

