package io.embrace.android.embracesdk;

import android.util.Pair;

import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumbs that represent tap events.
 */
final class TapBreadcrumb extends Breadcrumb {

    /**
     * Name of the tapped element.
     */
    @SerializedName("tt")
    private final String tappedElementName;

    /**
     * Screen position (coordinates) of the tapped element.
     */
    @SerializedName("tl")
    private final String location;

    /**
     * Type of TapBreadcrumb that categorizes the kind interaction, based on
     * {@link TapBreadcrumbType} types.
     */
    @SerializedName("t")
    private final TapBreadcrumbType type;

    TapBreadcrumb(Pair<Float, Float> point,
                  String tappedElementName,
                  long timestamp,
                  TapBreadcrumbType tapBreadcrumbType) {

        super(timestamp);
        this.type = tapBreadcrumbType;
        this.tappedElementName = tappedElementName;
        this.location = point != null ?
                point.first.intValue() + "," + point.second.intValue() :
                "0,0";
    }

    enum TapBreadcrumbType {
        @SerializedName("s")
        TAP,
        @SerializedName("l")
        LONG_PRESS;
    }
}
