package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Represents performance info for a {@link Session}. This had to be sub-classed, as the API requires
 * the same key, 'nr', be used to represent two completely different objects. In order to overload
 * this key, we need two implementations of the {@link PerformanceInfo}.
 * <p>
 * For a {@link Session} this contains a network timeline.
 */
final class SessionPerformanceInfo extends PerformanceInfo {

    @SerializedName("nr")
    private final NetworkSession networkSession;

    private SessionPerformanceInfo(Builder builder) {
        super(builder);
        this.networkSession = builder.networkSession;
    }

    public static SessionPerformanceInfo.Builder newBuilder() {
        return new SessionPerformanceInfo.Builder();
    }


    static class Builder extends PerformanceInfo.Builder {
        private NetworkSession networkSession;

        private Builder() {
        }


        public Builder withNetworkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }


        public SessionPerformanceInfo build() {
            return new SessionPerformanceInfo(this);
        }
    }
}
