package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * An occasion where the device reported that the memory is running low, due to a trim memory
 * event being called in {@link EmbraceActivityService}.
 *
 * @see <a href="https://developer.android.com/reference/android/content/ComponentCallbacks2.html#onTrimMemory(int)">onTrimMemory(int)</a>
 */
final class MemoryWarning {
    /** The timestamp at which the memory trim event occurred. */
    @SerializedName("ts")
    private final long timestamp;

    MemoryWarning(long timestamp) {
        this.timestamp = timestamp;
    }
}
