package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

/**
 * Intervals during which the UI thread was blocked for more than 1 second, which
 * determines that the application is not responding (ANR).
 */
final class AnrInterval {
    /** The type of thread not responding. Currently only the UI thread is monitored. */
    enum Type {
        @SerializedName("ui")
        UI
    }

    /** The time at which the application stopped responding. */
    @SerializedName("st")
    private final long startTime;

    /** The last time the thread was alive. */
    @SerializedName("lk")
    private final long lastKnownTime;

    /** The time the application started responding. */
    @SerializedName("en")
    private final long endTime;

    /** The component of the application which stopped responding. */
    @SerializedName("v")
    private final Type type;

    public AnrInterval(long startTime, long lastKnownTime, long endTime, Type type) {
        this.startTime = startTime;
        this.lastKnownTime = lastKnownTime;
        this.endTime = endTime;
        this.type = type;
    }
}
