/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import java.util.List;

class Session {
    @SerializedName(value="id")
    private final String sessionId;
    @SerializedName(value="st")
    private final Long startTime;
    @SerializedName(value="et")
    private final Long endTime;
    @SerializedName(value="sn")
    private final Integer number;
    @SerializedName(value="ht")
    private final Long lastHeartbeatTime;
    @SerializedName(value="tt")
    private final Long terminationTime;
    @SerializedName(value="ls")
    private final String lastState;
    @SerializedName(value="ba")
    private final Double startingBatteryLevel;
    @SerializedName(value="ce")
    private final Boolean endedCleanly;
    @SerializedName(value="tr")
    private final Boolean receivedTermination;
    @SerializedName(value="cs")
    private final Boolean coldStart;
    @SerializedName(value="ss")
    private final List<String> storyIds;
    @SerializedName(value="t")
    private final String sessionType;
    @SerializedName(value="il")
    private final List<String> infoLogIds;
    @SerializedName(value="el")
    private final List<String> errorLogIds;
    @SerializedName(value="wl")
    private final List<String> warningLogIds;
    @SerializedName(value="cr")
    private final Boolean crashed;

    public String getSessionId() {
        return this.sessionId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getNumber() {
        return this.number;
    }

    public Long getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    public Long getTerminationTime() {
        return this.terminationTime;
    }

    public String getLastState() {
        return this.lastState;
    }

    public Double getStartingBatteryLevel() {
        return this.startingBatteryLevel;
    }

    public Boolean isEndedCleanly() {
        return this.endedCleanly;
    }

    public Boolean isReceivedTermination() {
        return this.receivedTermination;
    }

    public Boolean isColdStart() {
        return this.coldStart;
    }

    public List<String> getStoryIds() {
        return this.storyIds;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public List<String> getInfoLogIds() {
        return this.infoLogIds;
    }

    public List<String> getErrorLogIds() {
        return this.errorLogIds;
    }

    public List<String> getWarningLogIds() {
        return this.warningLogIds;
    }

    private Session(Builder builder) {
        this.sessionId = builder.sessionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.number = builder.number;
        this.lastHeartbeatTime = builder.lastHeartbeatTime;
        this.terminationTime = builder.terminationTime;
        this.lastState = builder.lastState;
        this.startingBatteryLevel = builder.startingBatteryLevel;
        this.endedCleanly = builder.endedCleanly;
        this.receivedTermination = builder.receivedTermination;
        this.coldStart = builder.coldStart;
        this.storyIds = builder.storyIds;
        this.sessionType = builder.sessionType;
        this.infoLogIds = builder.infoLogIds;
        this.errorLogIds = builder.errorLogIds;
        this.warningLogIds = builder.warningLogIds;
        this.crashed = builder.crashed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Session copy) {
        Builder builder = new Builder();
        builder.sessionId = copy.getSessionId();
        builder.startTime = copy.getStartTime();
        builder.endTime = copy.getEndTime();
        builder.number = copy.getNumber();
        builder.lastHeartbeatTime = copy.getLastHeartbeatTime();
        builder.terminationTime = copy.getTerminationTime();
        builder.lastState = copy.getLastState();
        builder.startingBatteryLevel = copy.getStartingBatteryLevel();
        builder.endedCleanly = copy.isEndedCleanly();
        builder.receivedTermination = copy.isReceivedTermination();
        builder.coldStart = copy.isColdStart();
        builder.storyIds = copy.getStoryIds();
        builder.sessionType = copy.getSessionType();
        builder.infoLogIds = copy.getInfoLogIds();
        builder.errorLogIds = copy.getErrorLogIds();
        builder.warningLogIds = copy.getWarningLogIds();
        return builder;
    }

    public static final class Builder {
        private String sessionId;
        private Long startTime;
        private Long endTime;
        private Integer number;
        private Long lastHeartbeatTime;
        private Long terminationTime;
        private String lastState;
        private Double startingBatteryLevel;
        private Boolean endedCleanly;
        private Boolean receivedTermination;
        private Boolean coldStart;
        private List<String> storyIds;
        private String sessionType;
        private List<String> infoLogIds;
        private List<String> errorLogIds;
        private List<String> warningLogIds;
        private Boolean crashed;

        private Builder() {
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withStartTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder withEndTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder withNumber(Integer number) {
            this.number = number;
            return this;
        }

        public Builder withLastHeartbeatTime(Long lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        public Builder withTerminationTime(Long terminationTime) {
            this.terminationTime = terminationTime;
            return this;
        }

        public Builder withLastState(String lastState) {
            this.lastState = lastState;
            return this;
        }

        public Builder withStartingBatteryLevel(double startingBatteryLevel) {
            this.startingBatteryLevel = startingBatteryLevel;
            return this;
        }

        public Builder withEndedCleanly(boolean endedCleanly) {
            this.endedCleanly = endedCleanly;
            return this;
        }

        public Builder withReceivedTermination(boolean receivedTermination) {
            this.receivedTermination = receivedTermination;
            return this;
        }

        public Builder withColdStart(boolean coldStart) {
            this.coldStart = coldStart;
            return this;
        }

        public Builder withStoryIds(List<String> storyIds) {
            this.storyIds = storyIds;
            return this;
        }

        public Builder withSessionType(String sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        public Builder withInfoLogIds(List<String> infoLogIds) {
            this.infoLogIds = infoLogIds;
            return this;
        }

        public Builder withErrorLogIds(List<String> errorLogIds) {
            this.errorLogIds = errorLogIds;
            return this;
        }

        public Builder withWarningLogIds(List<String> warningLogIds) {
            this.warningLogIds = warningLogIds;
            return this;
        }

        public Builder withCrashed(boolean crashed) {
            this.crashed = crashed;
            return this;
        }

        public Session build() {
            return new Session(this);
        }
    }
}

