/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.embracesdk.EmbraceLogger;
import java.lang.reflect.Method;

final class SignalStrength {
    @SerializedName(value="ts")
    private final Long timestamp;
    @SerializedName(value="crs")
    private final Integer cdmaDbm;
    @SerializedName(value="cec")
    private final Integer cdmaEcio;
    @SerializedName(value="eec")
    private final Integer evdoEcio;
    @SerializedName(value="esn")
    private final Integer evdoSnr;
    @SerializedName(value="gbe")
    private final Integer gsmBitErrorRate;
    @SerializedName(value="gss")
    private final Integer gsmSignalStrength;
    @SerializedName(value="gsm")
    private final boolean gsm;
    @SerializedName(value="lss")
    private final Integer lteSignalStrength;
    @SerializedName(value="lrp")
    private final Integer lteRsrp;
    @SerializedName(value="lrq")
    private final Integer lteRsrq;
    @SerializedName(value="lsn")
    private final Integer lteRssnr;
    @SerializedName(value="lcq")
    private final Integer lteCqi;

    private SignalStrength(Long timestamp, Integer cdmaDbm, Integer cdmaEcio, Integer evdoEcio, Integer evdoSnr, Integer gsmBitErrorRate, Integer gsmSignalStrength, boolean gsm, Integer lteSignalStrength, Integer lteRsrp, Integer lteRsrq, Integer lteRssnr, Integer lteCqi) {
        this.timestamp = timestamp;
        this.cdmaDbm = cdmaDbm;
        this.cdmaEcio = cdmaEcio;
        this.evdoEcio = evdoEcio;
        this.evdoSnr = evdoSnr;
        this.gsmBitErrorRate = gsmBitErrorRate;
        this.gsmSignalStrength = gsmSignalStrength;
        this.gsm = gsm;
        this.lteSignalStrength = lteSignalStrength;
        this.lteRsrp = lteRsrp;
        this.lteRsrq = lteRsrq;
        this.lteRssnr = lteRssnr;
        this.lteCqi = lteCqi;
    }

    static SignalStrength of(android.telephony.SignalStrength signalStrength) {
        Integer lteSignalStrength = null;
        Integer lteRsrp = null;
        Integer lteRsrq = null;
        Integer lteRssnr = null;
        Integer lteCqi = null;
        try {
            Method[] methods;
            block16: for (Method mthd : methods = android.telephony.SignalStrength.class.getMethods()) {
                switch (mthd.getName()) {
                    case "getLteSignalStrength": {
                        lteSignalStrength = (Integer)mthd.invoke((Object)signalStrength, new Object[0]);
                        continue block16;
                    }
                    case "getLteRsrp": {
                        lteRsrp = (Integer)mthd.invoke((Object)signalStrength, new Object[0]);
                        continue block16;
                    }
                    case "getLteRsrq": {
                        lteRsrq = (Integer)mthd.invoke((Object)signalStrength, new Object[0]);
                        continue block16;
                    }
                    case "getLteRssnr": {
                        lteRssnr = (Integer)mthd.invoke((Object)signalStrength, new Object[0]);
                        continue block16;
                    }
                    case "getLteCqi": {
                        lteCqi = (Integer)mthd.invoke((Object)signalStrength, new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            EmbraceLogger.logDebug("Failed to access LTE signal strength values", ex);
        }
        return new SignalStrength(System.currentTimeMillis(), signalStrength.getCdmaDbm(), signalStrength.getCdmaEcio(), signalStrength.getEvdoEcio(), signalStrength.getEvdoSnr(), signalStrength.getGsmBitErrorRate(), signalStrength.getGsmSignalStrength(), signalStrength.isGsm(), lteSignalStrength, lteRsrp, lteRsrq, lteRssnr, lteCqi);
    }
}

