package io.embrace.android.embracesdk;

/**
 * Service for taking a screenshot of the app for a slow moment or a particular log event.
 */
interface ScreenshotService {
    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param logId the ID of the event
     * @return whether the screenshot was successfully taken or not
     */
    boolean takeScreenshotLogEvent(String logId);

    /**
     * Take a screenshot which is associated with a particular event in the logs.
     *
     * @param storyId the ID of the story
     * @return whether the screenshot was successfully taken or not
     */
    boolean takeScreenshotMoment(String storyId);
}
